/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;

import com.clustercontrol.ws.cloud.CloudStorageBackup;

public class StorageBackup extends Element implements IStorageBackup {
	StorageBackupRoot root;
	CloudStorageBackup cloudStorageBackup;

	private ExistStatusType existStatus;

	private StorageBackup(StorageBackupRoot root){
		this.root = root;
	}

	@Override
	public StorageBackupRoot getStorageBackupRoot() {
		return root;
	}

	@Override
	public String getSnapshotId() {
		return cloudStorageBackup.getSnapshotId();
	}

	@Override
	public String getSnapshotName() {
		return cloudStorageBackup.getSnapshotName();
	}

	@Override
	public String getCloudId() {
		return cloudStorageBackup.getCloudId();
	}

	@Override
	public String getDescription() {
		return cloudStorageBackup.getDescription();
	}

	@Override
	public String getVolumeId() {
		return cloudStorageBackup.getStorageId();
	}

	@Override
	public String getRegion() {
		return cloudStorageBackup.getRegion();
	}

	@Override
	public String getAvailabilityZone() {
		return cloudStorageBackup.getAvailabilityZone();
	}
	
	@Override
	public ExistStatusType getExistsStatus() {
		return existStatus;
	}

	@Override
	public Integer getStorageSize() {
		return cloudStorageBackup.getStorageSize();
	}
	
	@Override
	public Date getRegDate() {
		return new Date(cloudStorageBackup.getRegDate());
	}
	
	@Override
	public String getRegUser() {
		return cloudStorageBackup.getRegUser();
	}

	public void setVolumeId(String volumeId) {
		cloudStorageBackup.setStorageId(volumeId);
	}

	public void setExistsStatus(ExistStatusType status) {
		internalSet("existStatus", p2.existStatus, status);
	}

	public static StorageBackup createStorageBackup(StorageBackupRoot root, CloudStorageBackup cloudStorageBackup) {
		StorageBackup storageBackup = new StorageBackup(root);
		storageBackup.overwriteByCloudStorageBackup(cloudStorageBackup);
		return storageBackup;
	}

	public void internalUpdate(CloudStorageBackup cloudStorageBackup) {
		overwriteByCloudStorageBackup(cloudStorageBackup);
	}

	public void overwriteByCloudStorageBackup(CloudStorageBackup cloudStorageBackup) {
		this.cloudStorageBackup = cloudStorageBackup;
		setExistsStatus(cloudStorageBackup.getRestoreStatus() != null ? ExistStatusType.byNumber(cloudStorageBackup.getRestoreStatus()): null);
	}

	@Override
	public String getStorageName() {
		return cloudStorageBackup.getStorageName();
	}
}