/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudStorage;

public class Storage extends Element implements IStorage {
	private StorageRoot root;
	
	private String storageId;
	private String storageName;
	private String storageType;
	private String storageKind;
	private String cloudId;
	private String cloudUserId;
	private String facilityId;
	private String facilityName;
	private Integer deviceIndex;
	private String state;
	private Integer size;
	private Integer iops;
	private String deviceType;
	private String deviceName;
	private String availabilityZone;
	private RegistStateType registState;
	private StorageAttachment storageAttachment;
	private String snapshotId;
	private List<Tag> tags;
	
	private Date regDate;
	private Date updateDate;
	private String regUser;
	private String updateUser;

	public Storage(StorageRoot root) {
		this.root = root;
	}

	@Override
	public StorageRoot getStorageRoot() {
		return root;
	}

	@Override
	public String getStorageId() {
		return storageId;
	}
	public void setStorageId(String storageId) {
		this.storageId = storageId;
	}

	@Override
	public String getStorageName() {
		return storageName;
	}
	public void setStorageName(String storageName) {
		this.storageName = storageName;
	}

	@Override
	public String getStorageType() {
		return storageType;
	}
	public void setStorageType(String storageType) {
		this.storageType = storageType;
	}

	@Override
	public String getCloudId() {
		return cloudId;
	}
	public void setCloudId(String cloudId) {
		this.cloudId = cloudId;
	}

	@Override
	public String getCloudUserId() {
		return cloudUserId;
	}
	public void setCloudUserId(String cloudUserId) {
		this.cloudUserId = cloudUserId;
	}

	@Override
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		internalSet("facilityId", p2.facilityId, facilityId);
	}

	@Override
	public Integer getDeviceIndex() {
		return deviceIndex;
	}
	public void setDeviceIndex(Integer deviceIndex) {
		internalSet("deviceIndex", p2.deviceIndex, deviceIndex);
	}

	@Override
	public String getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(String deviceType) {
		internalSet("deviceType", p2.deviceType, deviceType);
	}

	@Override
	public String getDeviceName() {
		return deviceName;
	}
	public void setDeviceName(String deviceName) {
		internalSet("deviceName", p2.deviceName, deviceName);
	}

	@Override
	public Region getRegion() {
		return getStorageRoot().getRegion();
	}

	@Override
	public String getAvailabilityZone() {
		return availabilityZone;
	}
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}

	@Override
	public RegistStateType getRegistState() {
		return registState;
	}
	public void setRegistState(RegistStateType registState) {
		this.registState = registState;
	}

	@Override
	public Date getRegDate() {
		return regDate;
	}
	public void setRegDate(Date regDate) {
		this.regDate = regDate;
	}

	@Override
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}

	@Override
	public String getRegUser() {
		return regUser;
	}
	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}

	@Override
	public String getUpdateUser() {
		return updateUser;
	}
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}
	
	@Override
	public void update() throws CloudModelException {
		CloudStorage cloudStorage = CacheService.getSingleton().get(this, CloudStorage.class);
		if (cloudStorage == null) {
			try {
				CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
				cloudStorage = endpoint.getStorage(getRegion().getRegionName(), getStorageId());
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error("faild to get repositry tree.", e);
			}
		}
		else {
			CacheService.getSingleton().remove(this);
		}

		if (cloudStorage != null) {
			internalUpdate(cloudStorage);
		}
		
		super.update();
	}

	public void internalUpdate(CloudStorage cloudStorage) {
		overwriteByCloudStorage(cloudStorage);
	}
	
	public static Storage createStorage(StorageRoot root, CloudStorage cloudStorage) {
		Storage newStorage = new Storage(root);
		newStorage.overwriteByCloudStorage(cloudStorage);
		return newStorage;
	}

	protected void overwriteByCloudStorage(CloudStorage cloudStorage) {
		this.setStorageId(cloudStorage.getStorageId());
		this.setStorageType(cloudStorage.getStorageType());
		this.setStorageKind(cloudStorage.getStorageKind());
		this.setStorageName(cloudStorage.getStorageName());
		this.setState(cloudStorage.getState());
		this.setSnapshotId(cloudStorage.getSnapshotId());
		this.setSize(cloudStorage.getSize());
		this.setIops(cloudStorage.getIops());
		this.setCloudId(cloudStorage.getCloudId());
		this.setCloudUserId(cloudStorage.getCloudUserId());
		this.setDeviceIndex(cloudStorage.getDeviceIndex());
		this.setDeviceType(cloudStorage.getDeviceType());
		this.setDeviceName(cloudStorage.getDeviceName());
		this.setFacilityId(cloudStorage.getFacilityId());
		this.setFacilityName(cloudStorage.getFacilityName());
		this.setAvailabilityZone(cloudStorage.getAvailabilityZone());
		this.setRegistState(RegistStateType.valueOf(cloudStorage.getRegistState().value()));
		List<Tag> tags = new ArrayList<Tag>();
		for (com.clustercontrol.ws.cloud.Tag t: cloudStorage.getTags()) {
			tags.add(new Tag(t.getName(), t.getValue()));
		}
		this.setTags(tags);
		this.setRegDate(cloudStorage.getRegDate() != null ? new Date(cloudStorage.getRegDate()): null);
		this.setUpdateDate(cloudStorage.getUpdateDate() != null ? new Date(cloudStorage.getUpdateDate()): null);
		this.setRegUser(cloudStorage.getRegUser());
		this.setUpdateUser(cloudStorage.getUpdateUser());
		
		if (cloudStorage.getStorageAttachment() != null) {
			com.clustercontrol.ws.cloud.StorageAttachment wsVa = cloudStorage.getStorageAttachment();
			StorageAttachment va = new StorageAttachment(wsVa.getInstanceId(), wsVa.getDevice(), wsVa.getState(), wsVa.isDeleteOnTerminate(), wsVa.getAttachTime() == null ? null: new Date(wsVa.getAttachTime()));
			this.setStorageAttachment(va);
		}
		else {
			this.setStorageAttachment(null);
		}
	}

	@Override
	public Integer getSize() {
		return size;
	}
	public void setSize(Integer size) {
		this.size = size;
	}

	@Override
	public String getSnapshotId() {
		return snapshotId;
	}
	public void setSnapshotId(String snapshotId) {
		this.snapshotId = snapshotId;
	}

	@Override
	public Integer getIops() {
		return iops;
	}
	public void setIops(Integer iops) {
		this.iops = iops;
	}

	@Override
	public StorageAttachment getStorageAttachment() {
		return storageAttachment;
	}
	public void setStorageAttachment(StorageAttachment storageAttachment) {
		internalSet("storageAttachment", p2.storageAttachment, storageAttachment);
	}

	@Override
	public void attachInstance(String instanceId, String deviceName) {
		try {
			getCloudResourceManager().getEndpoint(CloudEndpoint.class).attachStorage(getRegion().getRegionName(), instanceId, getStorageId(), deviceName);
			update();
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void detachInstance() {
		if (this.getStorageAttachment() != null) {
			try {
				getCloudResourceManager().getEndpoint(CloudEndpoint.class).detachStorage(getRegion().getRegionName(), this.getStorageAttachment().getInstanceId(), getStorageId());
//				デタッチの場合、update を呼んでもすぐ反映しないのでコメントアウト。
//				update();
			}
			catch (Exception e) {
				throw new CloudModelException(e);
			}
		}
	}

	@Override
	public CloudResourceManager getCloudResourceManager() {
		return getRegion().getCloudResourceManager();
	}

	@Override
	public String getStorageKind() {
		return storageKind;
	}
	public void setStorageKind(String storageKind) {
		this.storageKind = storageKind;
	}

	@Override
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		internalSet("facilityName", p2.facilityName, facilityName);
	}

	@Override
	public String getState() {
		return state;
	}
	public void setState(String state) {
		internalSet("state", p2.state, state);
	}

	@Override
	public List<Tag> getTags() {
		return tags;
	}
	public void setTags(List<Tag> tags) {
		internalSet("tags", p2.tags, tags);
	}
}