///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//package com.clustercontrol.cloud.aws.presenter;
//
//import java.util.ArrayList;
//import java.util.List;
//
//import com.clustercontrol.ws.cloud.CloudSecurityGroup;
//import com.clustercontrol.ws.cloud.IpPermission;
//
//public class SecurityGroup extends Element implements ISecurityGroup {
//	NetworkSecurityRoot root;
//	CloudSecurityGroup cloudSecurityGroup;
//	List<IpPermissionImpl> ipPermissions = new ArrayList<IpPermissionImpl>();
//	
//	public SecurityGroup(NetworkSecurityRoot root){
//		this.root = root;
//	}
//
//	public SecurityGroup(NetworkSecurityRoot root, CloudSecurityGroup cloudSecurityGroup){
//		this.root = root;
//		this.overwriteSecurityGroup(cloudSecurityGroup);
//	}
//	
//	@Override
//	public String getSecurityGroupId() {
//		return cloudSecurityGroup.getSecurityGroupId();
//	}
//
//	@Override
//	public String getSecurityGroupName() {
//		return cloudSecurityGroup.getSecurityGroupName();
//	}
//
//	@Override
//	public String getVpcId() {
//		return cloudSecurityGroup.getVpcId();
//	}
//
//	@Override
//	public String getDescription() {
//		return cloudSecurityGroup.getDescription();
//	}
//
//	@Override
//	public List<IIpPermission> getIpPermissions() {
//		return new ArrayList<IIpPermission>(ipPermissions);
//	}
//
//	public void setSecurityGroupId(String securityGroupId) {
//		cloudSecurityGroup.setSecurityGroupId(securityGroupId);
//	}
//
//	public void setSecurityGroupName(String securityGroupName) {
//		cloudSecurityGroup.setSecurityGroupName(securityGroupName);
//	}
//
//	public void setVpcId(String vpcId) {
//		cloudSecurityGroup.setVpcId(vpcId);
//	}
//
//	public void setDescription(String description) {
//		cloudSecurityGroup.setDescription(description);
//	}
//
//	public void setIpPermissions(List<IpPermission> ipPermissions) {
//		List<IpPermission> list = cloudSecurityGroup.getIpPermissions();
//		list.clear();
//		list.addAll(ipPermissions);
//	}
//
//	@Override
//	public INetworkSecurityRoot getNetworkSecurityRoot() {
//		return root;
//	}
//
//	@Override
//	public IIpPermission authorizeIpPermission(AuthorizeIpPermissionRequest request) {
//		IIpPermission ipPermission = root.authorizeIpPermission(request);
//		ipPermissions.add((IpPermissionImpl)ipPermission);
//		fireElementAdded(ISecurityGroup.p2.ipPermissions, ipPermission);
//		return ipPermission;
//	}
//
//	@Override
//	public void revokeIpPermission(IIpPermission ipPermission) {
//		root.revokeIpPermission(ipPermission);
//		ipPermissions.remove(ipPermission);
//		fireElementRemoved(ISecurityGroup.p2.ipPermissions, ipPermission);
//	}
//	
//	public void internalUpdate(CloudSecurityGroup cloudSecurityGroup) {
//		overwriteSecurityGroup(cloudSecurityGroup);
//	}
//	
//	protected void overwriteSecurityGroup(CloudSecurityGroup cloudSecurityGroup) {
//		this.cloudSecurityGroup = cloudSecurityGroup;
//		for(IpPermission ipPermission: cloudSecurityGroup.getIpPermissions()){
//			ipPermissions.add(new IpPermissionImpl(this, ipPermission));
//		}
//	}
//
//	public static SecurityGroup createSecurityGroup(NetworkSecurityRoot root, CloudSecurityGroup cloudSecurityGroup) {
//		SecurityGroup securityGroup = new SecurityGroup(root, cloudSecurityGroup);
//		return securityGroup;
//	}
//
//	@Override
//	public Region getRegion() {
//		return root.getRegion();
//	}
//
//	@Override
//	public ICloudResourceManager getCloudResourceManager() {
//		return root.getCloudResourceManager();
//	}
//}
