/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;




public class Node extends Facility implements INode {
	private Scope parent;
	
	public Node() {
	}
	
	@Override
	public IFacilityRoot getFacilityRoot() {
		return getParent().getFacilityRoot();
	}

	@Override
	public Scope getParent() {
		return parent;
	}
	
	public void setParent(Scope parent) {
		internalSet("parent", INode.p2.parent, parent);
	}

	@Override
	public Scope getRegionScope() {
		Scope region = parent;
		while (region != null) { 
			if (region.getScopeType() == IScope.ScopeType.region) {
				return region;
			}
			region = region.getParent();
		}
		return null;
	}

	@Override
	public IScope getAvailabilityZoneScope() {
		Scope az = parent;
		while (az != null) { 
			if (az.getScopeType() == IScope.ScopeType.availabilityZone) {
				return az;
			}
			az = az.getParent();
		}
		return null;
	}
}
