///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//package com.clustercontrol.cloud.aws.presenter;
//
//import java.util.ArrayList;
//import java.util.Collections;
//import java.util.Iterator;
//import java.util.List;
//
//import com.clustercontrol.ws.cloud.CloudEndpoint;
//import com.clustercontrol.ws.cloud.CloudSecurityGroup;
//import com.clustercontrol.ws.cloud.IpPermission;
//
//public class NetworkSecurityRoot extends Element implements INetworkSecurityRoot {
//	private Region region;
//	private List<SecurityGroup> securityGroups;
//
//	public NetworkSecurityRoot(Region region) {
//		this.region = region;
//	}
//	
//	@Override
//	public void update() throws CloudModelException {
//		List<CloudSecurityGroup> cloudSecurityGroups = Collections.emptyList();
//
//		try {
//			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
//			cloudSecurityGroups = endpoint.getSecurityGroupsByRegion(region.getRegionName());
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
//
//		internalUpdate(cloudSecurityGroups);
//
//		super.update();
//	}
//
//	public boolean isInitialized() {
//		return securityGroups != null;
//	}
//	
//	private List<SecurityGroup> getSecurityGroupList() {
//		if (!isInitialized()) {
//			update();
//		}
//		return securityGroups;
//	}
//
//	public void internalUpdate(List<CloudSecurityGroup> cloudSecurityGroups) throws CloudModelException {
//		if (isInitialized()) {
//			List<SecurityGroup> securityGroupsTemp = new ArrayList<SecurityGroup>(securityGroups);
//			List<CloudSecurityGroup> cloudSecurityGroupsTemp = new ArrayList<CloudSecurityGroup>(cloudSecurityGroups);
//			Iterator<CloudSecurityGroup> cloudSecurityGroupsIter = cloudSecurityGroupsTemp.iterator();
//			while (cloudSecurityGroupsIter.hasNext()) {
//				CloudSecurityGroup csg = cloudSecurityGroupsIter.next();
//				
//				Iterator<SecurityGroup> securityGroupsIter = securityGroupsTemp.iterator();
//				while (securityGroupsIter.hasNext()) {
//					SecurityGroup sg = securityGroupsIter.next();
//					
//					if (csg.getRegion().equals(sg.getRegion().getRegionName()) && csg.getSecurityGroupId().equals(sg.getSecurityGroupId())) {
//						sg.internalUpdate(csg);
//
//						securityGroupsIter.remove();
//						cloudSecurityGroupsIter.remove();
//						break;
//					}
//				}
//			}
//
//			for (SecurityGroup sg: securityGroupsTemp) {
//				getSecurityGroupList().remove(sg);
//				fireElementRemoved(p2.securityGroups, sg);
//			}
//
//			for (CloudSecurityGroup csg: cloudSecurityGroupsTemp) {
//				SecurityGroup newSecurityGroup = SecurityGroup.createSecurityGroup(this, csg);
//				getSecurityGroupList().add(newSecurityGroup);
//				this.fireElementAdded(p2.securityGroups, newSecurityGroup);
//			}
//		}
//		else {
//			List<SecurityGroup> tempSecurityGroups = new ArrayList<SecurityGroup>();
//			for (CloudSecurityGroup instanceBackup: cloudSecurityGroups) {
//				tempSecurityGroups.add(SecurityGroup.createSecurityGroup(this, instanceBackup));
//			}
//			securityGroups = tempSecurityGroups;
//		}
//	}
//
//	@Override
//	public Region getRegion() {
//		return region;
//	}
//
//	@Override
//	public SecurityGroup[] getSecurityGroups() {
//		return securityGroups.toArray(new SecurityGroup[0]);
//	}
//
//	@Override
//	public SecurityGroup getSecurityGroup(String securityGroupId) {
//		for(SecurityGroup sg: securityGroups){
//			if(sg.getSecurityGroupId().equals(securityGroupId)){
//				return sg;
//			}
//		}
//		return null;
//	}
//
//	@Override
//	public SecurityGroup createSecurityGroup(CreateSecurityGroupRequest request) {
//		
//		CloudSecurityGroup sg = new CloudSecurityGroup();
//		sg.setSecurityGroupName(request.getSecurityGroupName());
//		sg.setDescription(request.getDescription());
//
//		try {
//			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
//			sg = endpoint.addSecurityGroup(region.getRegionName(), sg);
//			SecurityGroup newSg = SecurityGroup.createSecurityGroup(this, sg);
//			securityGroups.add(newSg);
//			fireElementAdded(INetworkSecurityRoot.p2.securityGroups, newSg);
//
//			return newSg;
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
//	}
//
//	@Override
//	public void deleteSecurityGroup(String securityGroupId) {
//		try {
//			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
//			endpoint.removeSecurityGroup(region.getRegionName(), securityGroupId);
//			SecurityGroup rmSg = getSecurityGroup(securityGroupId);
//			securityGroups.remove(rmSg);
//			fireElementRemoved(INetworkSecurityRoot.p2.securityGroups, rmSg);
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
//	}
//
//	@Override
//	public IIpPermission authorizeIpPermission(AuthorizeIpPermissionRequest request) {
//		
//		IpPermission ipp = new IpPermission();
//		ipp.setIpProtocol(request.getIpProtocol());
//		ipp.setFromPort(request.getFromPort());
//		ipp.setToPort(request.getToPort());
//		ipp.setIpRange(request.getIpRange());
//		ipp.setUserId(request.getUserId());
//		ipp.setGroupName(request.getSourceSecurityGroupName());
//		
//		try {
//			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
//			IpPermission ipPermission = endpoint.authorizeIpPermission(region.getRegionName(), request.getSecurityGroupId(), ipp);
//			return new IpPermissionImpl(getSecurityGroup(request.getSecurityGroupId()), ipPermission);
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
//	}
//
//	@Override
//	public void revokeIpPermission(IIpPermission ipPermission) {
//		Integer index = securityGroups.indexOf(ipPermission.getSecurityGroup());
//		if(index != null){
//			SecurityGroup sg = securityGroups.get(index);
//			index = sg.getIpPermissions().indexOf(ipPermission);
//			if(index != null){
//				IpPermissionImpl ipp = (IpPermissionImpl) sg.getIpPermissions().get(index);
//				try {
//					CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
//					endpoint.revokeIpPermission(region.getRegionName(), sg.getSecurityGroupId(), ipp.getIpPermission());
//				}
//				catch (Exception e) {
//					throw new CloudModelException(e);
//				}
//			}
//		}
//	}
//	
//	@Override
//	public CloudResourceManager getCloudResourceManager() {
//		return region.getCloudResourceManager();
//	}
//}