/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudType;
import com.clustercontrol.ws.cloud.CloudUser;
import com.clustercontrol.ws.cloud.Filter;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;

public class IdentityManagement extends Element implements IIdentityManagement {
	private CloudResourceManager root;
	
	/**
	 * アクセスする際、非同期対応が必要。
	 */
	private final List<ICategory> categories = new ArrayList<ICategory>();

	public IdentityManagement(CloudResourceManager root) {
		this.root = root;
		try {
			restoreIdentityTree();
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	@Override
	public CloudResourceManager getCloudResourceManager() {
		return root;
	}

	@Override
	public Category[] getCategories() {
		return categories.toArray(new Category[0]);
	}

	private void restoreIdentityTree() throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception {
		CloudEndpoint ce = root.getEndpoint(CloudEndpoint.class);
		
		List<CloudType> cts = ce.getAllCloudType();
		for (CloudType ct: cts) {
			Category category = Category.createCategory(ct, root, this);

			Filter f = new Filter();
			f.setName("cloudId");
			f.getValues().add(ct.getCloudId());
			List<CloudUser> cus = ce.getCloudUsers(Arrays.asList(f));
			
			Map<String, Identity> identityMap = new HashMap<String, Identity>();
			List<CloudUser> tempList = new ArrayList<CloudUser>(cus);
			Iterator<CloudUser> tempIter = tempList.iterator();
			while (tempIter.hasNext()) {
				CloudUser cu = tempIter.next();
				if (cu.getParentCloudUserId() == null) {
					Identity id = Identity.createIdentiry(cu, root, category, null);
					category.addChildIdentity(id);
					tempIter.remove();
					
					identityMap.put(id.getId(), id);
				}
			}
			
			for (CloudUser cu: tempList) {
				Identity parent = identityMap.get(cu.getParentCloudUserId());
				
				if (parent != null) {
					Identity child = Identity.createIdentiry(cu, root, category, parent);
					parent.addChildIdentity(child);
				}
				else {
					Logger logger = Logger.getLogger(IdentityManagement.class); 
					logger.warn("orphen : " + cu.getCloudUserId());
				}
			}
			
			categories.add(category);
		}
	}
	@Override
	public IIdentity getIdentity(String id) {
		for (ICategory category: categories) {
			for (IIdentity parent: category.getIdentities()) {
				if (parent.getId().equals(id)) {
					return parent;
				}
				
				for (IIdentity child: parent.getIdentities()) {
					if (child.getId().equals(id)) {
						return child;
					}
				}
			}
		}
		return null;
	}
	@Override
	public void each(Verifier v) {
		for (ICategory category: categories) {
			for (IIdentity parent: category.getIdentities()) {
				v.velify(parent);
				
				for (IIdentity child: parent.getIdentities()) {
					v.velify(child);
				}
			}
		}
	}
	@Override
	public void update() throws InvalidStateException {
		for (ICategory c: categories) {
			c.update();
		}
		
		super.update();
	}
}
