/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;


public interface IStorageBackup extends IElement {
	public enum ExistStatusType {
		exist((short)0),
		nothing((short)1);

		private short num;
		
		private ExistStatusType(short num) {
			this.num = num;
		}
		
		public short number() {
			return num;
		}
		
		public static ExistStatusType byNumber(short num) {
			for (ExistStatusType type: ExistStatusType.values()) {
				if (type.number() == num) {
					return type;
				}
			}
			return null;
		}
	}

	interface p2 {
		static final PropertyId2<ValueObserver2<ExistStatusType>> existStatus = new PropertyId2<ValueObserver2<ExistStatusType>>();
	}
	
	IStorageBackupRoot getStorageBackupRoot();

	String getSnapshotId();
	String getSnapshotName();
	String getCloudId();
	String getDescription();
	String getVolumeId();
	String getStorageName();
	String getRegion();
	String getAvailabilityZone();
	ExistStatusType getExistsStatus();
	Integer getStorageSize();
	Date getRegDate();
	String getRegUser();
}
