/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;
import java.util.List;



public interface IInstance extends IElement {
	// インスタンスの状態
	public enum StateType {
		pending("pending"),
		running("running"),
		shutting_down("shutting-down"),
		terminated("terminated"),
		stopping("stopping"),
		stopped("stopped"),
		rebooting("rebooting");
		
		private final String label;
		
		private StateType(String label) {
			this.label = label;
		}

		public String label() {
			return label;
		}
		
		public static StateType byLabel(String label) {
			String name = label.replace('-', '_');
			return valueOf(name);
		}
	}

	// インスタンスの状態
	public enum RegistStateType {
		registered((short)0),
		unregistered((short)1),
		deleted((short)2);

		private short num;
		
		private RegistStateType(short num) {
			this.num = num;
		}
		
		public short number() {
			return num;
		}
		
		public static RegistStateType byNumber(short num) {
			for (RegistStateType type: RegistStateType.values()) {
				if (type.number() == num) {
					return type;
				}
			}
			return null;
		}
	}
	
	public class Tag {
		private String name;
		private String value;
		
		public Tag() {
		}

		public Tag(String name, String value) {
			this.name = name;
			this.value = value;
		}
		
		public String getName() {
			return name;
		}
		
		public String getValue() {
			return value;
		}
	}

	// プロパティの Id
	interface p2 {
		static final PropertyId2<ValueObserver2<StateType>> state = new PropertyId2<ValueObserver2<StateType>>();
		static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2<ValueObserver2<String>>();
	}
	
	IInstanceRoot getInstanceRoot();
	String getFacilityId();
	String getFacilityName();
	String getInstanceId();
	String getInstanceName();
	String getPlatform();
	String getCloudId();
	String getCloudUserId();
	IRegion getRegion();
	String getAvailabilityZone();
	List<GroupIdentifier> getSecurityGroups();
	String getPublicDnsName();
	String getImageId();
	String getRootDeviceType();
	StateType getState();
	RegistStateType getRegistState();
	String getType();
	String getKeyPair();
	Date getLaunchTime();
	List<Tag> getTags();
	String getTemplateId();
	Date getRegDate();
	Date getUpdateDate();
	String getRegUser();
	String getUpdateUser();
	
	void start();
	void stop();
	
	ICloudResourceManager getCloudResourceManager();

	void registNode(RegistNodeRequest request);

	void attachStorage(String volumeId, String device);
	void detachStorage(String volumeId);
	List<BlockDeviceMapping> getBlockDeviceMappings();

	//テンプレート用
	void start(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments);
	void stop(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments);
}