/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;


public interface IIdentity extends IElement {
	// プロパティの Id
	public interface p2 {
		static final PropertyId2<ValueObserver2<String>> name = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> id = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> description = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<AccessKey>> accessKey = new PropertyId2<ValueObserver2<AccessKey>>();
		static final PropertyId2<ValueObserver2<IIdentity>> parent = new PropertyId2<ValueObserver2<IIdentity>>();
		static final PropertyId2<ValueObserver2<ICategory>> category = new PropertyId2<ValueObserver2<ICategory>>();
		static final PropertyId2<ValueObserver2<Date>> regDate = new PropertyId2<ValueObserver2<Date>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Date>> updateDate = new PropertyId2<ValueObserver2<Date>>();
		static final PropertyId2<ValueObserver2<String>> updateUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<CollectionObserver2<IIdentity>> identities = new PropertyId2<CollectionObserver2<IIdentity>>();
		static final PropertyId2<ValueObserver2<String>> hinemosUserId = new PropertyId2<ValueObserver2<String>>();
	}

	String getName();
	String getId();
	String getDescription();
	AccessKey getAccessKey();
	IIdentity[] getIdentities();
	ICategory getCategory();
	IIdentity getParent();
	String getHinemosUserId();
	Date getRegDate();
	String getRegUser();
	Date getUpdateDate();
	String getUpdateUser();

	void createChildIdentity(CreateIdentityRequest request);
	void modifyIdentity(ModifyIdentityRequest request);
	void deleteChildIdentity(String childId);
}
