/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;
import java.util.List;

import com.clustercontrol.ws.notify.NotifyRelationInfo;

public interface IBillingAlarm extends IElement {
	public interface p2 {
		static final PropertyId2<ValueObserver2<Boolean>> validFlg = new PropertyId2<ValueObserver2<Boolean>>();
		static final PropertyId2<ValueObserver2<Double>> thresholdInfoLimit = new PropertyId2<ValueObserver2<Double>>();
		static final PropertyId2<ValueObserver2<Double>> thresholdWarnLimit = new PropertyId2<ValueObserver2<Double>>();
		static final PropertyId2<ValueObserver2<Date>> regDate = new PropertyId2<ValueObserver2<Date>>();
		static final PropertyId2<ValueObserver2<Date>> updateDate = new PropertyId2<ValueObserver2<Date>>();
		static final PropertyId2<ValueObserver2<String>> target = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> alarmName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> description = new PropertyId2<ValueObserver2<String>>();
	}

	IBillingAlarmService getBillingAlarmService();
	
	String getAlarmId();
	String getAlarmName();
	String getApplication();
	String getCloudId();
	String getCloudUserId();
	String getDescription();
	String getNotifyGroupId();
	List<NotifyRelationInfo> getNotifyRelationInfos();
	String getTarget();
	Double getThresholdInfoLimit();
	Double getThresholdWarnLimit();
	Boolean getValidFlg();
	Date getRegDate();
	Date getUpdateDate();
	String getRegUser();
	String getUpdateUser();
	
	void modify(ModifyBillingAlarmRequest request);
	
	void enableAlarm();
	void disableAlarm();
}