/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.aws.resources.Subnet;
import com.clustercontrol.cloud.aws.resources.Tag;
import com.clustercontrol.cloud.commons.util.ControlUtil;

public class CreateInstanceRequest implements Serializable {
	private static final long serialVersionUID = -4109958036466822934L;

	public String facilityId;
	public String facilityName;
	public String nodeName;
	public String description;
	public AvailabilityZone availabilityZone;
	public List<GroupIdentifier> securityGroups = new ArrayList<GroupIdentifier>();
	public Image image;
	public String instanceType;
	public String keyName;
	public List<Tag> tags = new ArrayList<Tag>();
	public Boolean monitoring;
	public Boolean disableApiTermination;
	public String instanceInitiatedShutdownBehavior;
	public Boolean ebsOptimized;
	public Boolean replaceNode;
	public Subnet subnet;
	
	public EbsBlockDevice rootBlockDevice;

	public CreateInstanceRequest deepCopy() {
		return ControlUtil.deepCopy(this);
	}
}