/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.notify.NotifyRelationInfo;


public class BillingAlarmService extends Element implements IBillingAlarmService {
	private Inventory iv;
	private List<BillingAlarm> billingAlarms;
	
	public BillingAlarmService(Inventory iv){
		this.iv = iv;
	}

	@Override
	public CloudResourceManager getCloudResourceManager() {
		return iv.getCloudResourceManager();
	}

	public Inventory getInventory() {
		return iv;
	}

	@Override
	public BillingAlarm[] getBillingAlarms() {
		if (billingAlarms == null) {
			billingAlarms = new ArrayList<BillingAlarm>();

			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			try {
				List<com.clustercontrol.ws.cloud.BillingAlarm> bas = ce.getAllBillingAlarm();
				for (com.clustercontrol.ws.cloud.BillingAlarm ba: bas) {
					BillingAlarm newBillingAlarm = BillingAlarm.createBillingAlarm(this, ba);
					billingAlarms.add(newBillingAlarm);
				}
			}
			catch (Exception e) {
				throw new CloudModelException(e);
			}
		}
		
		return billingAlarms.toArray(new BillingAlarm[0]);
	}
	
	@Override
	public void update() {
		try {
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			List<com.clustercontrol.ws.cloud.BillingAlarm> billindAlarms = ce.getAllBillingAlarm();
			internalUpdate(billindAlarms);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	public void internalUpdate(List<com.clustercontrol.ws.cloud.BillingAlarm> wsBillingAlarms) throws CloudModelException {
		List<BillingAlarm> billingAlarmsTemp = new ArrayList<BillingAlarm>(billingAlarms);
		List<com.clustercontrol.ws.cloud.BillingAlarm> wsBillingAlarmsTemp = new ArrayList<com.clustercontrol.ws.cloud.BillingAlarm>(wsBillingAlarms);
		Iterator<com.clustercontrol.ws.cloud.BillingAlarm> wsBillingAlarmsIter = wsBillingAlarmsTemp.iterator();
		while (wsBillingAlarmsIter.hasNext()) {
			com.clustercontrol.ws.cloud.BillingAlarm wsBa = wsBillingAlarmsIter.next();
			
			Iterator<BillingAlarm> billingAlarmsIter = billingAlarmsTemp.iterator();
			while (billingAlarmsIter.hasNext()) {
				BillingAlarm ba = billingAlarmsIter.next();
				
				if (wsBa.getAlarmId().equals(ba.getAlarmId())) {
					ba.internalUpdate(wsBa);

					billingAlarmsIter.remove();
					wsBillingAlarmsIter.remove();
					break;
				}
			}
		}

		for (BillingAlarm ba: billingAlarmsTemp) {
			billingAlarms.remove(ba);
			fireElementRemoved(p2.billingAlarms, ba);
		}

		for (com.clustercontrol.ws.cloud.BillingAlarm wsBillingAlarm: wsBillingAlarmsTemp) {
			BillingAlarm newBillingAlarm = BillingAlarm.createBillingAlarm(this, wsBillingAlarm);
			billingAlarms.add(newBillingAlarm);
			this.fireElementAdded(p2.billingAlarms, newBillingAlarm);
		}
	}
	
	@Override
	public BillingAlarm createBillingAlarm(CreateBillingAlarmRequest request){
		BillingAlarm newBillingAlarm = null;
		try {
			com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
			ba.setAlarmId(request.getAlarmId());
			ba.setAlarmName(request.getAlarmName());
			ba.setDescription(request.getDescription());
			ba.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId(HinemosModuleConstant.MONITOR_AWS_BILLING, request.getAlarmId()));
			ba.setTarget(request.getTarget());
			ba.setThresholdInfoLimit(request.getThresholdInfoLimit());
			ba.setThresholdWarnLimit(request.getThresholdWarnLimit());
			ba.setValidFlg(request.isValidFlg());
			List<NotifyRelationInfo> notifies = Collections.emptyList();
			if (request.getNotifyRelationInfos() != null) {
				notifies = request.getNotifyRelationInfos();
			}
			ba.getNotifyRelationInfos().addAll(notifies);
			
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			com.clustercontrol.ws.cloud.BillingAlarm addedAlarm = ce.addBillingAlarm(ba);

			newBillingAlarm = BillingAlarm.createBillingAlarm(this, addedAlarm);
			
			billingAlarms.add(newBillingAlarm);
			fireElementAdded(p2.billingAlarms, newBillingAlarm);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
		
		return newBillingAlarm;
	}

	@Override
	public void deleteBillingAlarm(String alarmId){
		try {
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			ce.removeBillingAlarm(alarmId);

			for (BillingAlarm billingAlarm: billingAlarms) {
				if (alarmId.equals(billingAlarm.getAlarmId())) {
					billingAlarms.remove(billingAlarm);
					fireElementRemoved(p2.billingAlarms, billingAlarm);
					break;
				}
			}
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
}
