/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.StartInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.cloud.ui.views.actions.MultiSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StartInstanceAction
extends MultiSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.StartInstanceAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        for (IInstance ec2Instance : selection) {
            if (IInstance.StateType.stopped == ec2Instance.getState()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void invoke(IAction action) {
        ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
        IInstance tmpInstance2 = null;
        StringBuffer sb = new StringBuffer();
        String confirmMessage = "";
        StartInstanceDialog.DialogOutput output = null;
        if (((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).size() > 1) {
            Iterator iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
            int i = 0;
            while (iter.hasNext()) {
                IInstance instance = (IInstance)iter.next();
                sb.append(this.bundle_view_label.getString("view.instance.column.facility_id") + " = " + instance.getFacilityId() + ", " + this.bundle_view_label.getString("view.instance.column.instance_id") + " = " + instance.getInstanceId());
                if (iter.hasNext()) {
                    sb.append(", ");
                }
                if (++i <= 10) continue;
                sb.append("\n");
                i = 0;
            }
            confirmMessage = this.bundle_messages.getString("views.actions.start_instance_confirm2") + "\n" + sb;
        } else {
            tmpInstance2 = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
            sb.append(this.bundle_view_label.getString("view.instance.column.facility_id") + " = " + tmpInstance2.getFacilityId() + ", " + this.bundle_view_label.getString("view.instance.column.instance_id") + " = " + tmpInstance2.getInstanceId());
            StartInstanceDialog dialog = new StartInstanceDialog(this.viewPart.getSite().getShell());
            StartInstanceDialog.DialogInput input = new StartInstanceDialog.DialogInput();
            input.setInstanceId(tmpInstance2.getInstanceId());
            input.setRegion(tmpInstance2.getRegion().getRegionName());
            if (tmpInstance2.getTemplateId() != null && !tmpInstance2.getTemplateId().equals("")) {
                input.setTemplateId(tmpInstance2.getTemplateId());
            }
            dialog.setInput(input);
            if (dialog.open() != 0) {
                return;
            }
            output = dialog.getOutput();
            confirmMessage = this.bundle_messages.getString("views.actions.start_instance_confirm") + "\n" + sb;
        }
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)confirmMessage)) {
            if (tmpInstance2 == null) {
                for (IInstance tmpInstance2 : (IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()) {
                    if (tmpInstance2.getTemplateId() != null && !tmpInstance2.getTemplateId().equals("")) {
                        ITemplate template = templateManagement.getTemplate(tmpInstance2.getTemplateId());
                        tmpInstance2.start(true, template.getStartJobId(), null);
                        continue;
                    }
                    tmpInstance2.start();
                }
            } else {
                tmpInstance2.start(output.getRunJobFlg(), output.getJobId(), output.getArguments());
            }
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.start_instance_result"));
            final Iterator iter2 = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
            InstancesView2 view = (InstancesView2)this.viewPart;
            view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    while (iter2.hasNext()) {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor((IInstance)iter2.next(), IInstance.StateType.running);
                    }
                }
            });
        }
    }
}

