/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.ui.dialogs.RestoreStorageBehavior;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RestoreStorageAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RestoreStorage";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
        IStorageBackup backup = (IStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        String region = backup.getRegion();
        if (region != null) {
            CreateStorageDialog.Model m = new CreateStorageDialog.Model();
            m.region = region;
            m.setAvailabilityZone(backup.getAvailabilityZone());
            m.setSnapshotId(backup.getSnapshotId());
            m.setStorageName(backup.getStorageName());
            m.setStorageSize(backup.getStorageSize());
            dialog.setInput(m);
        }
        CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
        dialog.setBehavior(new RestoreStorageBehavior(backup));
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_storage_confirm"))) {
                CreateStorageDialog.Model m = dialog.getOutput();
                IRegion r = backup.getStorageBackupRoot().getBackupManagement().getRegion();
                r.getStorageRoot().restore(m);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_storage_result"));
            } else {
                return;
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStorageBackup backup = (IStorageBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getExistsStatus() == null || backup.getExistsStatus() == IStorageBackup.ExistStatusType.nothing) {
            action.setEnabled(false);
        }
    }
}

