/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CreateIdentityRequest;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IIdentityManagement;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.RegistAccountDialog;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.UserInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class RegistAccountAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RegistAccount";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private IViewPart viewPart;

    @Override
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    @Override
    protected void invoke(IAction action) {
        ArrayList<String> hinemosUsers;
        IIdentity selectedIdentity = null;
        RegistAccountDialog.Type type = null;
        Object selected = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (selected instanceof IIdentity) {
            selectedIdentity = (IIdentity)selected;
            type = RegistAccountDialog.Type.user;
        } else if (selected instanceof ICategory) {
            type = RegistAccountDialog.Type.account;
        }
        RegistAccountDialog dialog = new RegistAccountDialog(this.viewPart.getSite().getShell(), RegistAccountDialog.Mode.regist, type);
        AccessEndpoint accessEndpoint = Activator.getEndpointManager().getEndpoint(AccessEndpoint.class);
        List allHinemosUsers = null;
        try {
            allHinemosUsers = accessEndpoint.getUserInfoList(null);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        final ArrayList allCloudUsers = new ArrayList();
        IIdentityManagement im = Activator.getDefault().getCloudManager().getIdentityManagement();
        im.each(new IIdentityManagement.Verifier(){

            @Override
            public void velify(IIdentity element) {
                allCloudUsers.add(element);
            }
        });
        Iterator userInfoIter = allHinemosUsers.iterator();
        block2: while (userInfoIter.hasNext()) {
            UserInfo ui = (UserInfo)userInfoIter.next();
            Iterator cloudUserIter = allCloudUsers.iterator();
            while (cloudUserIter.hasNext()) {
                IIdentity cu = (IIdentity)cloudUserIter.next();
                if (!ui.getId().equals(cu.getHinemosUserId())) continue;
                userInfoIter.remove();
                cloudUserIter.remove();
                continue block2;
            }
        }
        if (!allHinemosUsers.isEmpty()) {
            hinemosUsers = new ArrayList<String>();
            for (UserInfo ui : allHinemosUsers) {
                hinemosUsers.add(ui.getId());
            }
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)this.bundle_messages.getString("dialogs.warning.all_user_used"));
            return;
        }
        dialog.setUserIdList(hinemosUsers.toArray(new String[0]));
        dialog.setCategory(im.getCategories()[0]);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_user_confirm"))) {
                RegistAccountDialog.Model m = dialog.getOutput();
                CreateIdentityRequest request = new CreateIdentityRequest();
                request.id = m.id;
                request.name = m.name;
                request.description = m.description;
                request.key = m.key;
                request.hinemosUserId = m.hinemosUserId;
                if (selectedIdentity != null) {
                    selectedIdentity.createChildIdentity(request);
                } else {
                    m.category.createChildIdentity(request);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_user_result"));
            } else {
                return;
            }
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IIdentity && ((IIdentity)selection.getFirstElement()).getParent() == null || selection.getFirstElement() instanceof ICategory;
    }
}

