/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ModifyTemplateAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ModifyTemplateAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    private CloudResourceProvider provider = new CloudResourceProviderImpl(this.endpoint);
    private ITemplate template;

    @Override
    protected void invoke(IAction action) throws InvocationException {
        this.template = (ITemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
                private MessageManager bundle_region = MessageManager.getInstance("region");
                private List<TemplateJobUtil.TemplateJobnet> templateJobs;
                {
                    try {
                        this.templateJobs = TemplateJobUtil.getTemplateJobList(true);
                    }
                    catch (InvalidRole_Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        this.templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
                    }
                }

                @Override
                public void setupTemplateId(Text templateId) {
                    if (ModifyTemplateAction.this.template != null) {
                        templateId.setText(ModifyTemplateAction.this.template.getTemplateId());
                        templateId.setEditable(false);
                    }
                }

                @Override
                public void setupTemplateName(Text templateName) {
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getTemplateName() != null && !ModifyTemplateAction.this.template.getTemplateName().isEmpty()) {
                        templateName.setText(ModifyTemplateAction.this.template.getTemplateName());
                    }
                }

                @Override
                public void setupRegion(Combo region) {
                    for (String regionName : ModifyTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = this.bundle_region.getString(regionName);
                        region.add(regionLocaleName);
                        region.setData(regionLocaleName, (Object)regionName);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getRegion() != null && !ModifyTemplateAction.this.template.getRegion().equals("")) {
                        String regionLocaleName = this.bundle_region.getString(ModifyTemplateAction.this.template.getRegion());
                        region.select(region.indexOf(regionLocaleName));
                    } else {
                        region.select(0);
                    }
                }

                @Override
                public void setupAmi(Text ami, Button selectAmi) {
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getImageId() != null && !ModifyTemplateAction.this.template.getImageId().equals("") && ModifyTemplateAction.this.template.getRegion() != null && !ModifyTemplateAction.this.template.getRegion().equals("")) {
                        Filter f1 = new Filter();
                        f1.setName("image-id");
                        f1.setValues(Arrays.asList(ModifyTemplateAction.this.template.getImageId()));
                        List<Image> imageList = ModifyTemplateAction.this.provider.getImages(ModifyTemplateAction.this.template.getRegion(), Arrays.asList(f1));
                        if (!imageList.isEmpty()) {
                            Image image = imageList.get(0);
                            ami.setText("(" + image.getImageId() + ") " + image.getName());
                            ami.setData((Object)image);
                        }
                    }
                }

                @Override
                public void setupLaunchJobId(Combo launchJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        launchJobId.add(jobName);
                        launchJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getLaunchJobId() != null && !ModifyTemplateAction.this.template.getLaunchJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getLaunchJobId())) {
                        launchJobId.select(launchJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getLaunchJobId())));
                    }
                }

                @Override
                public void setupStartJobId(Combo startJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        startJobId.add(jobName);
                        startJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStartJobId() != null && !ModifyTemplateAction.this.template.getStartJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStartJobId())) {
                        startJobId.select(startJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStartJobId())));
                    }
                }

                @Override
                public void setupStopJobId(Combo stopJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        stopJobId.add(jobName);
                        stopJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStopJobId() != null && !ModifyTemplateAction.this.template.getStopJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStopJobId())) {
                        stopJobId.select(stopJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStopJobId())));
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.modify_template_confirm"))) {
                this.template.getTemplateManagement().modifyTemplate(this.template, dialog.getOutput());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.modify_template_result"));
            } else {
                return;
            }
        }
    }
}

