/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.aws.presenter.AccessKey;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.ModifyIdentityRequest;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.RegistAccountDialog;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditAccountAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditAccount";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) {
        RegistAccountDialog.Type type = null;
        IIdentity id = (IIdentity)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        type = id.getParent() != null ? RegistAccountDialog.Type.user : RegistAccountDialog.Type.account;
        RegistAccountDialog dialog = new RegistAccountDialog(this.viewPart.getSite().getShell(), RegistAccountDialog.Mode.modify, type);
        RegistAccountDialog.Model input = new RegistAccountDialog.Model();
        input.id = id.getId();
        input.name = id.getName();
        input.key = new AccessKey();
        input.key.setAccessKey(id.getAccessKey().getAccessKey());
        input.key.setSecretKey(id.getAccessKey().getSecretKey());
        input.description = id.getDescription();
        input.hinemosUserId = id.getHinemosUserId();
        input.category = id.getCategory();
        dialog.setInput(input);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(type == RegistAccountDialog.Type.account ? this.bundle_messages.getString("views.actions.edit_account_confirm") : this.bundle_messages.getString("views.actions.edit_user_confirm")))) {
                RegistAccountDialog.Model output = dialog.getOutput();
                ModifyIdentityRequest request = new ModifyIdentityRequest();
                request.name = output.name;
                request.description = output.description;
                request.key = output.key;
                request.hinemosUserId = output.hinemosUserId;
                id.modifyIdentity(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)(type == RegistAccountDialog.Type.account ? this.bundle_messages.getString("views.actions.edit_account_result") : this.bundle_messages.getString("views.actions.edit_user_result")));
            } else {
                return;
            }
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IIdentity;
    }
}

