/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.DetachInstanceDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DetachStorageAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DetachStorageAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        DetachInstanceDialog dialog = new DetachInstanceDialog(this.viewPart.getSite().getShell(), instance);
        if (dialog.open() == 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            Iterator<String> iter = dialog.getVolumes().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (iter.hasNext()) {
                    sb.append(", ");
                }
                if (++i <= 10) continue;
                sb.append("\n");
                i = 0;
            }
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.bundle_messages.getString("views.actions.detach_storage_confirm") + "\n" + sb))) {
                for (String vol : dialog.getVolumes()) {
                    instance.detachStorage(vol);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.detach_storage_result"));
            } else {
                return;
            }
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return instance.getRegistState() != IInstance.RegistStateType.deleted;
    }
}

