/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteInstanceAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DeleteInstanceAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

    @Override
    protected void invoke(IAction action) {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.bundle_messages.getString("views.actions.delete_instance_confirm") + "\n" + this.bundle_view_label.getString("view.instance.column.facility_id") + " = " + instance.getFacilityId() + ", " + this.bundle_view_label.getString("view.instance.column.instance_id") + " = " + instance.getInstanceId()))) {
            instance.getInstanceRoot().deleteInstance(instance.getInstanceId());
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.delete_instance_result"));
            InstancesView2 view = (InstancesView2)this.viewPart;
            view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FacilityTree.reflesh();
                }
            });
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !IInstance.RegistStateType.deleted.equals((Object)instance.getRegistState());
    }
}

