/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageBehavior;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.ui.views.StoragesView2;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

public class CreateStorageAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateStorageAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    public void invoke(IAction action) throws InvocationException {
        CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
        StoragesView2 view = (StoragesView2)this.viewPart;
        IRegion region = view.getActiveRegion();
        if (region != null) {
            CreateStorageDialog.Model m = new CreateStorageDialog.Model();
            m.region = region.getRegionName();
            if (view.getActiveZone() != null) {
                m.setAvailabilityZone(view.getActiveZone());
            }
            dialog.setInput(m);
        }
        CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
        dialog.setBehavior(new CreateStorageBehavior());
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_storage_confirm"))) {
                CreateStorageDialog.Model m = dialog.getOutput();
                IRegion r = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class).getRegion(m.region);
                r.getStorageRoot().createStorage(m);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_storage_result"));
            } else {
                return;
            }
        }
    }
}

