/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class CreateInstanceByTemplateAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateInstanceByTemplateAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private ITemplateManagement templateManagement;
    private ITemplate template;

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        TemplatesView view = (TemplatesView)this.viewPart;
        this.template = (ITemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        this.templateManagement = this.template.getTemplateManagement();
        String region = this.template.getRegion();
        CreateInstanceDialog.Model input = new CreateInstanceDialog.Model();
        input.regionName = region;
        dialog.setInput(input);
        CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
            private Combo region;

            @Override
            public void setupRegion(Combo region) {
                for (String regionName : this.provider.getAllRegion()) {
                    String regionLocaleName = this.bundle_region.getString(regionName);
                    region.add(regionLocaleName);
                    region.setData(regionLocaleName, (Object)regionName);
                }
                if (CreateInstanceByTemplateAction.this.template != null && CreateInstanceByTemplateAction.this.template.getRegion() != null) {
                    String regionLocaleName = this.bundle_region.getString(this.input.regionName);
                    region.select(region.indexOf(regionLocaleName));
                } else {
                    region.select(0);
                }
                this.region = region;
            }

            @Override
            public void setupAvailabilityZone(Combo availabilityZone) {
                for (AvailabilityZone zone : this.provider.getAvailabilityZones((String)this.region.getData(this.region.getText()))) {
                    availabilityZone.add(zone.getZoneName());
                }
                availabilityZone.select(0);
            }

            @Override
            public void setupKeyPair(Combo keyPair) {
                for (String keyName : this.provider.getKeyNames((String)this.region.getData(this.region.getText()))) {
                    keyPair.add(keyName);
                }
                if (keyPair.getItemCount() > 0) {
                    keyPair.setEnabled(true);
                    keyPair.select(0);
                } else {
                    keyPair.setEnabled(false);
                }
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(false);
                rdoTemplate.setSelection(true);
            }

            @Override
            public void setupAmi(Text ami, Button selectAmi) {
                ami.setEnabled(false);
                ami.setEditable(false);
                ami.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                selectAmi.setEnabled(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setSelection(true);
                HashMap<String, String> map = new HashMap<String, String>();
                for (ITemplate tmpTemplate : CreateInstanceByTemplateAction.this.templateManagement.getTemplates()) {
                    if (!tmpTemplate.getRegion().equals(this.region.getData(this.region.getText()))) continue;
                    String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                    template.add(tmpLabel);
                    template.setData(tmpLabel, (Object)tmpTemplate);
                    map.put(tmpTemplate.getTemplateId(), tmpLabel);
                }
                if (CreateInstanceByTemplateAction.this.template != null && map.containsKey(CreateInstanceByTemplateAction.this.template.getTemplateId())) {
                    template.select(template.indexOf((String)map.get(CreateInstanceByTemplateAction.this.template.getTemplateId())));
                }
                template.setEnabled(true);
                editArgument.setEnabled(true);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_instance_by_template_confirm"))) {
                CreateInstanceDialog.Model output = dialog.getOutput();
                IRegion r = this.templateManagement.getCloudResourceManager().getInventory().getFolder(IEC2Service.class).getRegion(this.template.getRegion());
                final IInstance instance = output.isTemplateUsed != false ? r.getInstanceRoot().createInstance(output, output.templateId, output.arguments) : r.getInstanceRoot().createInstance(output);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_instance_by_template_result"));
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, IInstance.StateType.running, IInstance.StateType.terminated, IInstance.StateType.stopped);
                        FacilityTree.reflesh();
                    }
                });
            } else {
                return;
            }
        }
    }
}

