/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.aws.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceBackupDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BackupInstanceAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupInstance";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CreateInstanceBackupDialog dialog = new CreateInstanceBackupDialog(this.viewPart.getSite().getShell(), instance);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_image_confirm"))) {
                CreateInstanceBackupRequest request = new CreateInstanceBackupRequest();
                request.setInstanceId(instance.getInstanceId());
                request.setImageName(dialog.getImageName());
                request.setDescription(dialog.getDescription());
                request.setNoReboot(dialog.getNoReboot());
                request.setWithEBSVolume(dialog.getWithEBSVolume());
                instance.getInstanceRoot().getRegion().getBackupManagement().getInstanceBackupRoot().createInstanceBackup(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_image_result"));
            } else {
                return;
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IInstance instance = (IInstance)((IStructuredSelection)selection).getFirstElement();
        if (instance == null || instance.getFacilityId() == null || "".equals(instance.getFacilityId()) || instance.getRegistState() == IInstance.RegistStateType.deleted) {
            action.setEnabled(false);
        }
    }
}

