/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IIdentityManagement;
import com.clustercontrol.cloud.aws.presenter.ValueObserver2;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class UsersView
extends ViewPart {
    public static final String Id = "com.clustercontrol.cloud.ui.views.UsersView";
    private Runnable refreshness = new Runnable(){

        @Override
        public void run() {
            UsersView.this.treeViewer.refresh(true);
            ISelection selection = UsersView.this.treeViewer.getSelection();
            UsersView.this.getSite().getSelectionProvider().setSelection(selection);
        }
    };
    private ValueObserver2<String> nameObserver = new ValueObserver2<String>(){

        @Override
        public void propertyChanged(ValueObserver2.ValueChangedEvent<String> event) {
            UsersView.this.getSite().getShell().getDisplay().asyncExec(UsersView.this.refreshness);
        }
    };
    private CollectionObserver2<IIdentity> identity4Category = new CollectionObserver2<IIdentity>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<IIdentity> event) {
            IIdentity element = event.getAddedElement();
            element.addPropertyObserver2(IIdentity.p2.name, UsersView.this.nameObserver);
            element.addPropertyObserver2(IIdentity.p2.identities, UsersView.this.identity4Identity);
            UsersView.this.getSite().getShell().getDisplay().asyncExec(UsersView.this.refreshness);
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<IIdentity> event) {
            IIdentity element = event.getRemovedElement();
            for (IIdentity child : element.getIdentities()) {
                child.removePropertyObserver2(IIdentity.p2.name, UsersView.this.nameObserver);
                child.removePropertyObserver2(IIdentity.p2.identities, UsersView.this.identity4Identity);
            }
            element.removePropertyObserver2(IIdentity.p2.name, UsersView.this.nameObserver);
            element.removePropertyObserver2(IIdentity.p2.identities, UsersView.this.identity4Identity);
            UsersView.this.getSite().getShell().getDisplay().asyncExec(UsersView.this.refreshness);
        }
    };
    private CollectionObserver2<IIdentity> identity4Identity = new CollectionObserver2<IIdentity>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<IIdentity> event) {
            IIdentity element = event.getAddedElement();
            element.addPropertyObserver2(IIdentity.p2.name, UsersView.this.nameObserver);
            UsersView.this.getSite().getShell().getDisplay().asyncExec(UsersView.this.refreshness);
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<IIdentity> event) {
            IElement element = event.getRemovedElement();
            element.removePropertyObserver2(IIdentity.p2.name, UsersView.this.nameObserver);
            UsersView.this.getSite().getShell().getDisplay().asyncExec(UsersView.this.refreshness);
        }
    };
    private IIdentityManagement im;
    private TreeViewer treeViewer;

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        composite.setLayout((Layout)new FillLayout(256));
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayout((Layout)new FillLayout(256));
        this.treeViewer = new TreeViewer(composite_1, 2816);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ICategory) {
                    return Activator.getDefault().getImageRegistry().get("aws-box");
                }
                if (element instanceof IIdentity) {
                    IIdentity identity = (IIdentity)element;
                    if (identity.getParent() == null) {
                        return Activator.getDefault().getImageRegistry().get("account");
                    }
                    return Activator.getDefault().getImageRegistry().get("user");
                }
                return Activator.getDefault().getImageRegistry().get("user");
            }

            public String getText(Object element) {
                if (element instanceof IIdentityManagement) {
                    return ((IIdentityManagement)element).toString();
                }
                if (element instanceof ICategory) {
                    return ((ICategory)element).getName() + " (" + ((ICategory)element).getId() + ")";
                }
                if (element instanceof IIdentity) {
                    return ((IIdentity)element).getName() + " (" + ((IIdentity)element).getId() + ")";
                }
                return "";
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        try {
            this.update();
        }
        catch (Throwable e) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.error((Object)e.getMessage(), e);
        }
    }

    private IIdentityManagement getIdentityManagement() {
        if (this.im == null) {
            try {
                this.im = Activator.getDefault().getCloudManager().getIdentityManagement();
                for (ICategory cat : this.im.getCategories()) {
                    cat.addPropertyObserver2(ICategory.p2.identities, this.identity4Category);
                    for (IIdentity parent : cat.getIdentities()) {
                        parent.addPropertyObserver2(IIdentity.p2.name, this.nameObserver);
                        parent.addPropertyObserver2(IIdentity.p2.identities, this.identity4Identity);
                        for (IIdentity child : parent.getIdentities()) {
                            child.addPropertyObserver2(IIdentity.p2.name, this.nameObserver);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(UsersView.class);
                logger.warn((Object)"fail to gey accounts", (Throwable)e);
            }
        }
        return this.im;
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void update() {
        if (this.im == null) {
            this.im = this.getIdentityManagement();
            if (this.im != null) {
                this.treeViewer.setInput((Object)this.im);
            }
        } else {
            this.im.update();
        }
    }

    public void dispose() {
        Activator.getDefault().releaseCloudManager();
        super.dispose();
    }

    private class TreeContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IIdentityManagement) {
                return ((IIdentityManagement)parentElement).getCategories();
            }
            if (parentElement instanceof ICategory) {
                return ((ICategory)parentElement).getIdentities();
            }
            if (parentElement instanceof IIdentity) {
                return ((IIdentity)parentElement).getIdentities();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ICategory) {
                return ((ICategory)element).getIdentityManagement();
            }
            if (element instanceof IIdentity) {
                IIdentity id = (IIdentity)element;
                if (id.getParent() != null) {
                    return id.getParent();
                }
                return id.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IIdentityManagement) {
                return ((IIdentityManagement)element).getCategories().length != 0;
            }
            if (element instanceof ICategory) {
                return ((ICategory)element).getIdentities().length != 0;
            }
            if (element instanceof IIdentity) {
                return ((IIdentity)element).getIdentities().length != 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            assert (inputElement instanceof IIdentityManagement);
            return ((IIdentityManagement)inputElement).getCategories();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

