/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class TemplatesView
extends ViewPart {
    public static final String Id = "com.clustercontrol.cloud.ui.views.TemplatesView";
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private Table table;
    private TableViewer tableViewer;
    private Label lblHeader;
    private Label lblFooter;
    private ITemplateManagement templateManagement;
    private List<ITemplate> templates;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
    private String footerTitle = this.bundle_view_label.getString("view.template.footer_title");
    private CollectionObserver2<ITemplate> elementObserver = new CollectionObserver2<ITemplate>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<ITemplate> event) {
            event.getAddedElement().addPropertyObserver2(IElement.allProperty, TemplatesView.this.propertyObserver);
            TemplatesView.this.templates.add(event.getAddedElement());
            TemplatesView.this.tableViewer.setInput((Object)TemplatesView.this.templates);
            TemplatesView.this.lblFooter.setText(TemplatesView.this.footerTitle + TemplatesView.this.templates.size());
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<ITemplate> event) {
            event.getRemovedElement().removePropertyObserver2(IElement.allProperty, TemplatesView.this.propertyObserver);
            TemplatesView.this.templates.remove(event.getRemovedElement());
            TemplatesView.this.tableViewer.setInput((Object)TemplatesView.this.templates);
            TemplatesView.this.lblFooter.setText(TemplatesView.this.footerTitle + TemplatesView.this.templates.size());
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        LinkedHashMap<String, ColumnLabelProvider> tableColumnMap = new LinkedHashMap<String, ColumnLabelProvider>();
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.template_id"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getTemplateId();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.template_name"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getTemplateName();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.image_id"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getImageId();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.launch_job_id"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getLaunchJobId();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.region"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getRegion();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.reg_date"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getRegDate() != null ? TemplatesView.this.format.format(((ITemplate)element).getRegDate().getTime()) : null;
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.update_date"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getUpdateDate() != null ? TemplatesView.this.format.format(((ITemplate)element).getUpdateDate().getTime()) : null;
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.reg_user"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getRegUser();
            }
        });
        tableColumnMap.put(this.bundle_view_label.getString("view.template.column.update_user"), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ITemplate)element).getUpdateUser();
            }
        });
        TableViewerColumn[] tableViewerColumns = new TableViewerColumn[tableColumnMap.size()];
        TableColumn[] tableColumns = new TableColumn[tableColumnMap.size()];
        int i = 0;
        for (final Map.Entry entry : tableColumnMap.entrySet()) {
            tableViewerColumns[i] = new TableViewerColumn(this.tableViewer, 0);
            tableColumns[i] = tableViewerColumns[i].getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumns[i], (ColumnLayoutData)new ColumnPixelData(100, true, true));
            tableColumns[i].setText((String)entry.getKey());
            tableViewerColumns[i].setLabelProvider((CellLabelProvider)entry.getValue());
            tableColumns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TemplatesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(TemplatesView.this.tableViewer, (ColumnLabelProvider)entry.getValue()));
                }
            });
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.lblFooter = new Label(composite, 0);
        this.lblFooter.setAlignment(131072);
        this.lblFooter.setSize(this.lblFooter.getSize().x, 80);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblFooter.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        try {
            this.update();
        }
        catch (Throwable e) {
            this.lblFooter.setText(this.footerTitle + 0);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.error((Object)e.getMessage(), e);
        }
    }

    private List<ITemplate> getTemplates() {
        if (this.templates == null) {
            try {
                this.templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
                this.templateManagement.addPropertyObserver2(ITemplateManagement.p2.templates, this.elementObserver);
                for (ITemplate template : this.templateManagement.getTemplates()) {
                    template.addPropertyObserver2(IElement.allProperty, this.propertyObserver);
                }
                this.templates = new ArrayList<ITemplate>();
                this.templates.addAll(Arrays.asList(this.templateManagement.getTemplates()));
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(TemplatesView.class);
                logger.warn((Object)"fail to get templates", (Throwable)e);
                this.templates = new ArrayList<ITemplate>();
            }
        }
        return this.templates;
    }

    public void update() {
        if (this.templates != null) {
            for (ITemplate template : this.templates) {
                template.removePropertyObserver2(IElement.allProperty, this.propertyObserver);
            }
            this.templates = null;
        }
        if (this.templateManagement != null) {
            this.templateManagement.removePropertyObserver2(ITemplateManagement.p2.templates, this.elementObserver);
            this.templateManagement.update();
        }
        List<ITemplate> billingAlarms = this.getTemplates();
        this.tableViewer.setInput(billingAlarms);
        this.lblFooter.setText(this.footerTitle + billingAlarms.size());
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }
}

