/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.presenter.IStorageBackupRoot;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.StorageBackupRoot;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree2;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudStorageBackup;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;

public class StorageBackupView
extends FilterlingViewPartByScopeTree2<IStorageBackupRoot, IStorageBackup, CloudStorageBackup> {
    public static final String Id = "com.clustercontrol.cloud.ui.views.StorageBackupView";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private Table table;
    private TableViewer tableViewer;
    private Label lblHeader;
    private FooterComposite footerComposite;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn.setText(this.bundle_view_label.getString("view.storage_backup.column.snapshot_id"));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getSnapshotId();
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_1, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_1.setText(this.bundle_view_label.getString("view.storage_backup.column.snapshot_name"));
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getSnapshotName();
            }
        });
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_2, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_2.setText(this.bundle_view_label.getString("view.storage_backup.column.cloud_id"));
        tableViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getCloudId();
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_3, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_3.setText(this.bundle_view_label.getString("view.storage_backup.column.description"));
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getDescription();
            }
        });
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_4, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_4.setText(this.bundle_view_label.getString("view.storage_backup.column.volume_id"));
        tableViewerColumn_4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getVolumeId();
            }
        });
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_5, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_5.setText(this.bundle_view_label.getString("view.storage_backup.column.exist_status"));
        tableViewerColumn_5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                switch (((IStorageBackup)element).getExistsStatus()) {
                    case exist: {
                        return StorageBackupView.this.bundle_view_label.getString("view.storage_backup.exist");
                    }
                    case nothing: {
                        return StorageBackupView.this.bundle_view_label.getString("view.storage_backup.nothing");
                    }
                }
                throw new InvalidStateException();
            }
        });
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_6, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_6.setText(this.bundle_view_label.getString("view.storage_backup.column.reg_date"));
        tableViewerColumn_6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return StorageBackupView.this.format.format(((IStorageBackup)element).getRegDate());
            }
        });
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_7, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_7.setText(this.bundle_view_label.getString("view.storage_backup.column.reg_user"));
        tableViewerColumn_7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorageBackup)element).getRegUser();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.update();
    }

    @Override
    protected String getHeaderByElementId(IRegion region, List<String> elementIds) {
        if (!elementIds.isEmpty()) {
            return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName()) + " " + this.bundle_view_label.getString("view.storage_backup.header_title2") + elementIds.get(0);
        }
        return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName());
    }

    @Override
    protected String getElementId(Object selected) {
        if (selected instanceof IStorage) {
            return ((IStorage)selected).getStorageId();
        }
        return null;
    }

    @Override
    protected boolean isMatchRegion(IRegion region, IStorageBackup element) {
        return region.getRegionName().equals(element.getRegion());
    }

    @Override
    protected boolean isMatchFacilityIds(List<String> elementIds, IStorageBackup element) {
        if (elementIds.isEmpty() || elementIds.size() > 1) {
            return false;
        }
        return element.getVolumeId().equals(elementIds.get(0));
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected String getSupportViewId() {
        return "com.clustercontrol.cloud.ui.views.StoragesView2";
    }

    @Override
    protected IStorageBackupRoot getRootElement(IRegion region) {
        return region.getBackupManagement().getStorageBackupRoot();
    }

    @Override
    protected List<IStorageBackup> getElements(IStorageBackupRoot root) {
        return Arrays.asList(root.getStorageBackups());
    }

    @Override
    protected PropertyId2<CollectionObserver2<IStorageBackup>> getPropertyId() {
        return IStorageBackupRoot.p2.storageBackups;
    }

    @Override
    protected List<CloudStorageBackup> getManagerElements(CloudEndpoint endpoint, IRegion target) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
        return endpoint.getStorageBackupsByRegion(target.getRegionName());
    }

    @Override
    protected void setManagerElements(IStorageBackupRoot rootElement, List<CloudStorageBackup> managerElements) {
        ((StorageBackupRoot)rootElement).internalUpdate(managerElements);
    }

    @Override
    protected boolean isInitialized(IStorageBackupRoot rootElement) {
        return ((StorageBackupRoot)rootElement).isInitialized();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }
}

