/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.GroupIdentifier;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceRoot;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.InstanceRoot;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;

public class InstancesView2
extends FilterlingViewPartByScopeTree<IInstanceRoot, IInstance, CloudInstance>
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.InstancesView";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private MessageManager bundle_instance_state = MessageManager.getInstance("instance_state");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private Label lblHeader;
    private FooterComposite footerComposite;
    private Table table;
    private TableViewer tableViewer;
    private ISelectionProvider provider = new ISelectionProvider(){
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        ISelection theSelection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return this.theSelection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.theSelection = selection;
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (ISelectionChangedListener l : this.listeners) {
                l.selectionChanged(e);
            }
        }
    };

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn.setText(this.bundle_view_label.getString("view.instance.column.facility_id"));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getFacilityId();
            }
        });
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_2, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_2.setText(this.bundle_view_label.getString("view.instance.column.facility_name"));
        tableViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getFacilityName();
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_3, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_3.setText(this.bundle_view_label.getString("view.instance.column.instance_id"));
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getInstanceId();
            }
        });
        TableViewerColumn tableViewerColumn_15 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_15 = tableViewerColumn_15.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_15, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_15.setText(this.bundle_view_label.getString("view.instance.column.instance_name"));
        tableViewerColumn_15.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getInstanceName();
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_1, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_1.setText(this.bundle_view_label.getString("view.instance.column.platform"));
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getPlatform();
            }
        });
        TableViewerColumn tableViewerColumn_16 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_16 = tableViewerColumn_16.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_16, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_16.setText(this.bundle_view_label.getString("view.instance.column.cloud_id"));
        tableViewerColumn_16.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getCloudId();
            }
        });
        TableViewerColumn tableViewerColumn_22 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_22 = tableViewerColumn_22.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_22, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_22.setText(this.bundle_view_label.getString("view.instance.column.cloud_user_id"));
        tableViewerColumn_22.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getCloudUserId();
            }
        });
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_4, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_4.setText(this.bundle_view_label.getString("view.instance.column.region"));
        tableViewerColumn_4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String regionName = InstancesView2.this.bundle_region.getString(((IInstance)element).getRegion().getRegionName());
                return regionName != null ? regionName : ((IInstance)element).getRegion().getRegionName();
            }
        });
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_5, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_5.setText(this.bundle_view_label.getString("view.instance.column.availability_zone"));
        tableViewerColumn_5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getAvailabilityZone();
            }
        });
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_6, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_6.setText(this.bundle_view_label.getString("view.instance.column.security_group"));
        tableViewerColumn_6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstance instance = (IInstance)element;
                String securityGroups = null;
                if (!instance.getSecurityGroups().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < instance.getSecurityGroups().size(); ++i) {
                        GroupIdentifier gi = instance.getSecurityGroups().get(i);
                        sb.append(gi.getGroupName());
                        if (i == instance.getSecurityGroups().size() - 1) continue;
                        sb.append(", ");
                    }
                    securityGroups = sb.toString();
                } else {
                    securityGroups = "default";
                }
                return securityGroups;
            }
        });
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_7, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_7.setText(this.bundle_view_label.getString("view.instance.column.public_dns_name"));
        tableViewerColumn_7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getPublicDnsName();
            }
        });
        TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_8, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_8.setText(this.bundle_view_label.getString("view.instance.column.image_id"));
        tableViewerColumn_8.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getImageId();
            }
        });
        TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_9, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_9.setText(this.bundle_view_label.getString("view.instance.column.root_device_type"));
        tableViewerColumn_9.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getRootDeviceType();
            }
        });
        TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_10, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_10.setText(this.bundle_view_label.getString("view.instance.column.state"));
        tableViewerColumn_10.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((IInstance)element).getState() != null) {
                    String stateName = InstancesView2.this.bundle_instance_state.getString(((IInstance)element).getState().label());
                    return stateName != null ? stateName + " (" + ((IInstance)element).getState().label() + ")" : ((IInstance)element).getState().label();
                }
                return null;
            }
        });
        TableViewerColumn tableViewerColumn_17 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_17 = tableViewerColumn_17.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_17, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_17.setText(this.bundle_view_label.getString("view.instance.column.regist_state"));
        tableViewerColumn_17.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getRegistState().name();
            }
        });
        TableViewerColumn tableViewerColumn_11 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_11 = tableViewerColumn_11.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_11, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_11.setText(this.bundle_view_label.getString("view.instance.column.type"));
        tableViewerColumn_11.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getType();
            }
        });
        TableViewerColumn tableViewerColumn_12 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_12 = tableViewerColumn_12.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_12, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_12.setText(this.bundle_view_label.getString("view.instance.column.key_pair"));
        tableViewerColumn_12.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getKeyPair();
            }
        });
        TableViewerColumn tableViewerColumn_13 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_13 = tableViewerColumn_13.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_13, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_13.setText(this.bundle_view_label.getString("view.instance.column.launch_time"));
        tableViewerColumn_13.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getLaunchTime() != null ? ((IInstance)element).getLaunchTime().toString() : null;
            }
        });
        TableViewerColumn tableViewerColumn_14 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_14 = tableViewerColumn_14.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_14, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_14.setText(this.bundle_view_label.getString("view.instance.column.tags"));
        tableViewerColumn_14.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstance instance = (IInstance)element;
                String tags = null;
                if (!instance.getTags().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < instance.getTags().size(); ++i) {
                        IInstance.Tag tag = instance.getTags().get(i);
                        sb.append(tag.getName()).append("=").append(tag.getValue());
                        if (i == instance.getTags().size() - 1) continue;
                        sb.append("; ");
                    }
                    tags = sb.toString();
                } else {
                    tags = "";
                }
                return tags;
            }
        });
        TableViewerColumn tableViewerColumn_23 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_23 = tableViewerColumn_23.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_23, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_23.setText(this.bundle_view_label.getString("view.instance.column.template_id"));
        tableViewerColumn_23.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getTemplateId();
            }
        });
        TableViewerColumn tableViewerColumn_18 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_18 = tableViewerColumn_18.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_18, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_18.setText(this.bundle_view_label.getString("view.instance.column.reg_date"));
        tableViewerColumn_18.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getRegDate() != null ? ((IInstance)element).getRegDate().toString() : null;
            }
        });
        TableViewerColumn tableViewerColumn_19 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_19 = tableViewerColumn_19.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_19, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_19.setText(this.bundle_view_label.getString("view.instance.column.update_date"));
        tableViewerColumn_19.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getUpdateDate() != null ? ((IInstance)element).getUpdateDate().toString() : null;
            }
        });
        TableViewerColumn tableViewerColumn_20 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_20 = tableViewerColumn_20.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_20, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_20.setText(this.bundle_view_label.getString("view.instance.column.reg_user"));
        tableViewerColumn_20.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getRegUser() != null ? ((IInstance)element).getRegUser() : null;
            }
        });
        TableViewerColumn tableViewerColumn_21 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_21 = tableViewerColumn_21.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_21, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_21.setText(this.bundle_view_label.getString("view.instance.column.update_user"));
        tableViewerColumn_21.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstance)element).getUpdateUser() != null ? ((IInstance)element).getUpdateUser() : null;
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList selection = new ArrayList();
                if (event.getSelection() instanceof IStructuredSelection) {
                    Iterator iter = ((IStructuredSelection)event.getSelection()).iterator();
                    while (iter.hasNext()) {
                        selection.add(iter.next());
                    }
                }
                InstancesView2.this.provider.setSelection((ISelection)new StructuredSelection(selection.toArray()));
            }
        });
        this.getSite().setSelectionProvider(this.provider);
        this.update();
        this.createContextMenu();
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InstancesView2.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem addAction = (ActionContributionItem)toolbar.find("com.clustercontrol.cloud.ui.views.actions.ClipDnsAction");
        manager.add(addAction.getAction());
    }

    @Override
    protected IInstanceRoot getRootElement(IRegion region) {
        return region.getInstanceRoot();
    }

    @Override
    protected List<IInstance> getElements(IInstanceRoot root) {
        return Arrays.asList(root.getInstances());
    }

    @Override
    protected PropertyId2<CollectionObserver2<IInstance>> getPropertyId() {
        return IInstanceRoot.p2.instances;
    }

    @Override
    protected boolean isMatchRegion(IRegion region, IInstance element) {
        return element.getRegion() == region;
    }

    @Override
    protected boolean isMatchAvailabilityZone(String zoneName, IInstance element) {
        return zoneName.equals(element.getAvailabilityZone());
    }

    @Override
    protected boolean isMatchFacilityId(String facilityId, IInstance element) {
        return facilityId.equals(element.getFacilityId());
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected List<CloudInstance> getManagerElements(CloudEndpoint endpoint, IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
        return endpoint.getInstancesByRegion(region.getRegionName());
    }

    @Override
    protected void setManagerElements(IInstanceRoot rootElement, List<CloudInstance> ManagerElements) {
        ((InstanceRoot)rootElement).internalUpdate(ManagerElements);
    }

    @Override
    protected boolean isInitialized(IInstanceRoot rootElement) {
        return ((InstanceRoot)rootElement).isInitialized();
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }
}

