/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackup;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackupRoot;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.InstanceBackupRoot;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree2;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstanceBackup;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;

public class InstanceBackupView
extends FilterlingViewPartByScopeTree2<IInstanceBackupRoot, IInstanceBackup, CloudInstanceBackup>
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.InstanceBackupView";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private Table table;
    private TableViewer tableViewer;
    private Label lblHeader;
    private FooterComposite footerComposite;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn.setText(this.bundle_view_label.getString("view.instance_backup.column.image_id"));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getImageId();
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_1, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_1.setText(this.bundle_view_label.getString("view.instance_backup.column.image_name"));
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getImageName();
            }
        });
        TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_8, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_8.setText(this.bundle_view_label.getString("view.instance_backup.column.cloud_id"));
        tableViewerColumn_8.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getCloudId();
            }
        });
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_2, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_2.setText(this.bundle_view_label.getString("view.instance_backup.column.description"));
        tableViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getDescription();
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_3, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_3.setText(this.bundle_view_label.getString("view.instance_backup.column.image_type"));
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getImageType();
            }
        });
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_4, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_4.setText(this.bundle_view_label.getString("view.instance_backup.column.facility_id"));
        tableViewerColumn_4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getFacilityId();
            }
        });
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_5, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_5.setText(this.bundle_view_label.getString("view.instance_backup.column.instance_id"));
        tableViewerColumn_5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getInstanceId();
            }
        });
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_6, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_6.setText(this.bundle_view_label.getString("view.instance_backup.column.platform"));
        tableViewerColumn_6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstanceBackup backup = (IInstanceBackup)element;
                if (backup.getExistsStatus() == IInstanceBackup.ExistStatusType.exist) {
                    if (backup.getPlatform() != null && !"".equals(backup.getPlatform())) {
                        return backup.getPlatform();
                    }
                    return "Linux";
                }
                return null;
            }
        });
        TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_9, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_9.setText(this.bundle_view_label.getString("view.instance_backup.column.exist_status"));
        tableViewerColumn_9.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                switch (((IInstanceBackup)element).getExistsStatus()) {
                    case exist: {
                        return InstanceBackupView.this.bundle_view_label.getString("view.instance_backup.exist");
                    }
                    case nothing: {
                        return InstanceBackupView.this.bundle_view_label.getString("view.instance_backup.nothing");
                    }
                }
                throw new InvalidStateException();
            }
        });
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_7, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_7.setText(this.bundle_view_label.getString("view.instance_backup.column.reg_date"));
        tableViewerColumn_7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return InstanceBackupView.this.format.format(((IInstanceBackup)element).getRegDate());
            }
        });
        TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_10, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_10.setText(this.bundle_view_label.getString("view.instance_backup.column.reg_user"));
        tableViewerColumn_10.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IInstanceBackup)element).getRegUser();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.update();
    }

    @Override
    protected String getHeaderByElementId(IRegion region, List<String> elementIds) {
        if (!elementIds.isEmpty()) {
            return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName()) + " " + this.bundle_view_label.getString("view.instance.header_title3") + elementIds.get(0);
        }
        return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName());
    }

    @Override
    protected boolean isMatchRegion(IRegion region, IInstanceBackup element) {
        return region.getRegionName().equals(element.getRegion());
    }

    @Override
    protected boolean isMatchFacilityIds(List<String> facilityIds, IInstanceBackup element) {
        if (facilityIds.isEmpty() || facilityIds.size() > 1) {
            return false;
        }
        return element.getFacilityId().equals(facilityIds.get(0));
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected IInstanceBackupRoot getRootElement(IRegion region) {
        return region.getBackupManagement().getInstanceBackupRoot();
    }

    @Override
    protected List<IInstanceBackup> getElements(IInstanceBackupRoot root) {
        return Arrays.asList(root.getInstanceBackups());
    }

    @Override
    protected PropertyId2<CollectionObserver2<IInstanceBackup>> getPropertyId() {
        return IInstanceBackupRoot.p2.instanceBackups;
    }

    @Override
    protected List<CloudInstanceBackup> getManagerElements(CloudEndpoint endpoint, IRegion target) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
        return endpoint.getInstanceBackupsByRegion(target.getRegionName());
    }

    @Override
    protected void setManagerElements(IInstanceBackupRoot rootElement, List<CloudInstanceBackup> managerElements) {
        ((InstanceBackupRoot)rootElement).internalUpdate(managerElements);
    }

    @Override
    protected boolean isInitialized(IInstanceBackupRoot rootElement) {
        return ((InstanceBackupRoot)rootElement).isInitialized();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected String getElementId(Object selected) {
        if (selected instanceof IInstance) {
            return ((IInstance)selected).getFacilityId();
        }
        return null;
    }

    @Override
    protected String getSupportViewId() {
        return "com.clustercontrol.cloud.ui.views.InstancesView";
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }
}

