/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

public abstract class FilterlingViewPartByScopeTree2<R extends IElement, E extends IElement, M>
extends FilterlingViewPart<IRegion, R, E, M>
implements ISelectionListener {
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private List<String> elementIds;
    protected Map<IRegion, String> resultMap = new HashMap<IRegion, String>();

    @Override
    protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (viweId.equals("com.clustercontrol.cloud.ui.views.ScopeView")) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            if (sselection.isEmpty()) {
                this.setNextState(null);
                return true;
            }
            Object selected = sselection.getFirstElement();
            if (selected instanceof IScope) {
                IScope scope = (IScope)selected;
                switch (scope.getScopeType()) {
                    case root: {
                        this.setNextState(null);
                        break;
                    }
                    case region: {
                        IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
                        this.setNextState(ec2Service.getRegion(scope.getFacilityId()));
                        break;
                    }
                    case availabilityZone: {
                        IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
                        this.setNextState(ec2Service.getRegion(scope.getParent().getFacilityId()));
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else if (selected instanceof INode) {
                INode node = (INode)selected;
                IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
                this.setNextState(ec2Service.getRegion(node.getParent().getParent().getFacilityId()));
            }
            return true;
        }
        if (viweId.equals(this.getSupportViewId())) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            if (sselection.isEmpty()) {
                this.elementIds = Collections.emptyList();
            } else {
                this.elementIds = new ArrayList<String>();
                for (Object selected : sselection) {
                    String elementId = this.getElementId(selected);
                    if (elementId == null) continue;
                    this.elementIds.add(elementId);
                }
            }
            this.releaseElements();
            this.addElements();
        }
        return false;
    }

    protected abstract String getHeaderByElementId(IRegion var1, List<String> var2);

    protected String getHeaderByRegion(IRegion region) {
        return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName());
    }

    protected String getEmptyHeader() {
        return "";
    }

    protected abstract String getElementId(Object var1);

    @Override
    protected boolean isMatch(E element) {
        return this.getCurrentState() != null && this.isMatchRegion((IRegion)this.getCurrentState(), element) && (this.elementIds.isEmpty() || this.isMatchFacilityIds(this.elementIds, element));
    }

    protected abstract boolean isMatchRegion(IRegion var1, E var2);

    protected abstract boolean isMatchFacilityIds(List<String> var1, E var2);

    protected abstract Label getHeaderLabel();

    protected abstract String getSupportViewId();

    protected abstract Label getLeftFooter();

    protected abstract Label getRightFooter();

    @Override
    protected void failedPrepareFilterConditiion(Exception exception) {
        super.failedPrepareFilterConditiion(exception);
        this.getHeaderLabel().setText("");
        if (exception instanceof CloudModelException) {
            this.getLeftFooter().setText(((CloudModelException)exception).getMessage());
        } else {
            this.getLeftFooter().setText(this.bundle_view_label.getString("view.viewing_status.fail"));
        }
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    @Override
    protected void successGetManagerData(IRegion targetState, List<M> managerElements) {
        super.successGetManagerData(targetState, managerElements);
        this.resultMap.put(targetState, this.bundle_view_label.getString("view.viewing_status.success"));
    }

    @Override
    protected void failedGetManagerData(IRegion targetState, Exception exception) {
        super.failedGetManagerData(targetState, exception);
        this.resultMap.put(targetState, this.bundle_view_label.getString("view.viewing_status.fail"));
    }

    @Override
    protected void startGetManagerData(IRegion region) {
        this.getLeftFooter().setText(this.bundle_region.getString(region.getRegionName()) + " " + this.bundle_view_label.getString("view.viewing_status.under_access"));
    }

    @Override
    protected void nextState() {
        if (this.getCurrentState() != this.getNextState()) {
            this.elementIds = Collections.emptyList();
        }
        super.nextState();
    }

    @Override
    protected void updateStatus() {
        if (this.getCurrentState() != null) {
            if (!this.elementIds.isEmpty()) {
                this.getHeaderLabel().setText(this.getHeaderByElementId((IRegion)this.getCurrentState(), this.elementIds));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    @Override
    protected void updateStatus(Exception exception) {
        if (this.getCurrentState() != null) {
            if (!this.elementIds.isEmpty()) {
                this.getHeaderLabel().setText(this.getHeaderByElementId((IRegion)this.getCurrentState(), this.elementIds));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    public IRegion getActiveRegion() {
        return (IRegion)this.getCurrentState();
    }

    @Override
    public void update() {
        ISelection selection = this.getSite().getPage().getSelection("com.clustercontrol.cloud.ui.views.ScopeView");
        this.update(new FilterlingViewPart.ConcreteDataHolder("com.clustercontrol.cloud.ui.views.ScopeView", selection), true);
    }
}

