/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

public abstract class FilterlingViewPartByScopeTree<R extends IElement, E extends IElement, M>
extends FilterlingViewPart<IRegion, R, E, M>
implements ISelectionListener {
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private String zoneName;
    private String facilityId;
    protected Map<IRegion, String> resultMap = new HashMap<IRegion, String>();

    @Override
    protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
        if (!viweId.equals("com.clustercontrol.cloud.ui.views.ScopeView")) {
            return false;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.isEmpty()) {
            return false;
        }
        Object selected = sselection.getFirstElement();
        if (selected instanceof IScope) {
            IScope scope = (IScope)selected;
            switch (scope.getScopeType()) {
                case root: {
                    this.setNextState(null);
                    this.zoneName = null;
                    this.facilityId = null;
                    break;
                }
                case region: {
                    IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
                    this.setNextState(ec2Service.getRegion(scope.getFacilityId()));
                    this.zoneName = null;
                    this.facilityId = null;
                    break;
                }
                case availabilityZone: {
                    IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
                    this.setNextState(ec2Service.getRegion(scope.getParent().getFacilityId()));
                    this.zoneName = scope.getFacilityId();
                    this.facilityId = null;
                    break;
                }
                default: {
                    return false;
                }
            }
        } else if (selected instanceof INode) {
            INode node = (INode)selected;
            IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
            this.setNextState(ec2Service.getRegion(node.getParent().getParent().getFacilityId()));
            this.zoneName = node.getParent().getFacilityId();
            this.facilityId = node.getFacilityId();
        }
        return true;
    }

    protected String getHeaderByFacilityId(IRegion region, String facilityId) {
        return this.bundle_view_label.getString("view.instance.header_title3") + facilityId;
    }

    protected String getHeaderByAvailabilityZone(IRegion region, String availabilityZone) {
        return this.bundle_view_label.getString("view.instance.header_title2") + this.bundle_region.getString(region.getRegionName()) + ", " + availabilityZone;
    }

    protected String getHeaderByRegion(IRegion region) {
        return this.bundle_view_label.getString("view.instance.header_title") + this.bundle_region.getString(region.getRegionName());
    }

    protected String getEmptyHeader() {
        return "";
    }

    @Override
    protected void startGetManagerData(IRegion region) {
        this.getLeftFooter().setText(this.bundle_region.getString(region.getRegionName()) + " " + this.bundle_view_label.getString("view.viewing_status.under_access"));
    }

    @Override
    protected boolean isMatch(E element) {
        return !(this.getCurrentState() == null || !this.isMatchRegion((IRegion)this.getCurrentState(), element) || this.zoneName != null && !this.isMatchAvailabilityZone(this.zoneName, element) || this.facilityId != null && !this.isMatchFacilityId(this.facilityId, element));
    }

    protected abstract boolean isMatchRegion(IRegion var1, E var2);

    protected abstract boolean isMatchAvailabilityZone(String var1, E var2);

    protected abstract boolean isMatchFacilityId(String var1, E var2);

    protected abstract Label getHeaderLabel();

    protected abstract Label getLeftFooter();

    protected abstract Label getRightFooter();

    @Override
    protected void failedPrepareFilterConditiion(Exception exception) {
        super.failedPrepareFilterConditiion(exception);
        this.getHeaderLabel().setText("");
        if (exception instanceof CloudModelException) {
            this.getLeftFooter().setText(((CloudModelException)exception).getMessage());
        } else {
            this.getLeftFooter().setText(this.bundle_view_label.getString("view.viewing_status.fail"));
        }
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    @Override
    protected void successGetManagerData(IRegion targetState, List<M> managerElements) {
        super.successGetManagerData(targetState, managerElements);
        this.resultMap.put(targetState, this.bundle_view_label.getString("view.viewing_status.success"));
    }

    @Override
    protected void failedGetManagerData(IRegion targetState, Exception exception) {
        super.failedGetManagerData(targetState, exception);
        this.resultMap.put(targetState, this.bundle_view_label.getString("view.viewing_status.fail"));
    }

    @Override
    protected void updateStatus() {
        if (this.getCurrentState() != null) {
            if (this.getActiveFacilityId() != null) {
                this.getHeaderLabel().setText(this.getHeaderByFacilityId((IRegion)this.getCurrentState(), this.getActiveFacilityId()));
            } else if (this.getActiveZone() != null) {
                this.getHeaderLabel().setText(this.getHeaderByAvailabilityZone((IRegion)this.getCurrentState(), this.getActiveZone()));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    @Override
    protected void updateStatus(Exception exception) {
        if (this.getCurrentState() != null) {
            if (this.getActiveFacilityId() != null) {
                this.getHeaderLabel().setText(this.getHeaderByFacilityId((IRegion)this.getCurrentState(), this.getActiveFacilityId()));
            } else if (this.getActiveZone() != null) {
                this.getHeaderLabel().setText(this.getHeaderByAvailabilityZone((IRegion)this.getCurrentState(), this.getActiveZone()));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_view_label.getString("view.billing_alarm.footer_title") + this.getCurrentElements().size());
    }

    public IRegion getActiveRegion() {
        return (IRegion)this.getCurrentState();
    }

    public String getActiveZone() {
        return this.zoneName;
    }

    public String getActiveFacilityId() {
        return this.facilityId;
    }

    @Override
    public void update() {
        ISelection selection = this.getSite().getPage().getSelection("com.clustercontrol.cloud.ui.views.ScopeView");
        this.update(new FilterlingViewPart.ConcreteDataHolder("com.clustercontrol.cloud.ui.views.ScopeView", selection), true);
    }
}

