/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.ui.views.AsyncUpdateViewPart;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class FilterlingViewPart<S, R extends IElement, E extends IElement, M>
extends AsyncUpdateViewPart
implements ISelectionListener {
    private CollectionObserver2<E> elementObserver = new CollectionObserver2<E>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<E> event) {
            ((IElement)event.getAddedElement()).addPropertyObserver2(IElement.allProperty, FilterlingViewPart.this.propertyObserver);
            IElement element = (IElement)event.getAddedElement();
            if (FilterlingViewPart.this.isMatch(element)) {
                FilterlingViewPart.this.elements.add(event.getAddedElement());
                FilterlingViewPart.this.getViewer().setInput((Object)FilterlingViewPart.this.elements);
                FilterlingViewPart.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FilterlingViewPart.this.getViewer().refresh(true);
                        ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
                        FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
                    }
                });
            }
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<E> event) {
            ((IElement)event.getRemovedElement()).removePropertyObserver2(IElement.allProperty, FilterlingViewPart.this.propertyObserver);
            FilterlingViewPart.this.elements.remove(event.getRemovedElement());
            FilterlingViewPart.this.getViewer().setInput((Object)FilterlingViewPart.this.elements);
            FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilterlingViewPart.this.getViewer().refresh(true);
                    ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
                    FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilterlingViewPart.this.getViewer().refresh(true);
                    ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
                    FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilterlingViewPart.this.getViewer().refresh(true);
                    ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
                    FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilterlingViewPart.this.getViewer().refresh(true);
                    ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
                    FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private List<E> elements = Collections.emptyList();
    private S currentState;
    private S nextState;

    protected abstract boolean prepareFilterConditiion(String var1, ISelection var2);

    protected void failedPrepareFilterConditiion(Exception exception) {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.error((Object)exception.getMessage(), (Throwable)exception);
        this.updateNextState(exception);
    }

    protected void updateNextState() {
        this.releaseElements();
        this.nextState();
        this.addElements();
    }

    protected void updateNextState(Exception exception) {
        this.releaseElements();
        this.nextState();
        this.getViewer().setInput(this.elements);
        this.updateStatus(exception);
    }

    protected void releaseElements() {
        if (this.getCurrentState() != null) {
            this.removeRootListener(this.getRootElement(this.getCurrentState()));
        }
        for (IElement element : this.elements) {
            this.removeElementListener(element);
        }
        this.elements.clear();
    }

    protected void addElements() {
        this.elements = this.filterElements();
        for (IElement element : this.elements) {
            this.addElementListener(element);
        }
        if (this.currentState != null) {
            this.addRootListener(this.getRootElement(this.getCurrentState()));
        }
        this.getViewer().setInput(this.elements);
        this.updateStatus();
    }

    protected List<E> filterElements() {
        List elements = Collections.emptyList();
        if (this.getCurrentState() != null) {
            elements = new ArrayList();
            for (IElement element : this.getElements(this.getRootElement(this.getCurrentState()))) {
                if (!this.isMatch(element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    protected abstract R getRootElement(S var1);

    protected abstract List<E> getElements(R var1);

    protected abstract PropertyId2<CollectionObserver2<E>> getPropertyId();

    protected void addRootListener(R rootElement) {
        rootElement.addPropertyObserver2(this.getPropertyId(), this.elementObserver);
    }

    protected void removeRootListener(R rootElement) {
        rootElement.removePropertyObserver2(this.getPropertyId(), this.elementObserver);
    }

    protected void addElementListener(E element) {
        element.addPropertyObserver2(IElement.allProperty, (AllPropertyObserver)this.propertyObserver);
    }

    protected void removeElementListener(E element) {
        element.removePropertyObserver2(IElement.allProperty, (AllPropertyObserver)this.propertyObserver);
    }

    protected void nextState() {
        this.currentState = this.nextState;
    }

    protected abstract boolean isMatch(E var1);

    protected abstract List<M> getManagerElements(CloudEndpoint var1, S var2) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception;

    protected abstract void setManagerElements(R var1, List<M> var2);

    protected abstract boolean isInitialized(R var1);

    protected void updateStatus() {
    }

    protected void updateStatus(Exception exception) {
    }

    protected void startGetManagerData(S target) {
    }

    protected void successGetManagerData(S targetState, List<M> managerElements) {
        this.setManagerElements(this.getRootElement(targetState), managerElements);
    }

    protected void failedGetManagerData(S targetState, Exception exception) {
        List managerElements = Collections.emptyList();
        this.setManagerElements(this.getRootElement(targetState), managerElements);
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.error((Object)exception.getMessage(), (Throwable)exception);
    }

    public R getCurrentRootElement() {
        if (this.currentState != null) {
            return this.getRootElement(this.currentState);
        }
        return null;
    }

    public List<E> getCurrentElements() {
        return this.elements;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        long before = System.currentTimeMillis();
        this.update(new ConcreteDataHolder(part.getSite().getId(), selection), false);
        long after = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append("selectionChanged ").append("elapsedTime=").append(after - before).append("ms");
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.debug((Object)sb.toString());
    }

    protected S getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(S currentState) {
        this.currentState = currentState;
    }

    protected S getNextState() {
        return this.nextState;
    }

    protected void setNextState(S nextState) {
        this.nextState = nextState;
    }

    protected class ConcreteDataHolder
    implements AsyncUpdateViewPart.DataHolder<List<M>, S> {
        private String viewId;
        private ISelection selection;

        public ConcreteDataHolder(String viewId, ISelection selection) {
            this.viewId = viewId;
            this.selection = selection;
        }

        @Override
        public S getTargetState() {
            return FilterlingViewPart.this.nextState;
        }

        @Override
        public S getCurrentState() {
            return FilterlingViewPart.this.currentState;
        }

        @Override
        public List<M> asyncGetData(S targetState) {
            try {
                CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
                return FilterlingViewPart.this.getManagerElements(endpoint, targetState);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void syncSetData(S targetState, List<M> data) {
            FilterlingViewPart.this.successGetManagerData(targetState, data);
        }

        @Override
        public boolean isInitialized(S targetState) {
            return FilterlingViewPart.this.isInitialized(FilterlingViewPart.this.getRootElement(targetState));
        }

        @Override
        public boolean prepare() {
            return FilterlingViewPart.this.prepareFilterConditiion(this.viewId, this.selection);
        }

        @Override
        public void startAsyncCall(S targetState) {
            FilterlingViewPart.this.startGetManagerData(targetState);
        }

        @Override
        public void success() {
            FilterlingViewPart.this.updateNextState();
        }

        @Override
        public void error(Exception exception) {
            FilterlingViewPart.this.updateNextState(exception);
        }

        @Override
        public void failAsyncCall(S targetState, Exception exception) {
            FilterlingViewPart.this.failedGetManagerData(targetState, exception);
        }

        @Override
        public void failPrepareAsyncCall(Exception exception) {
            FilterlingViewPart.this.failedPrepareFilterConditiion(exception);
        }
    }
}

