/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class RegistNodeDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Text facilityName;
    private Text facilityId;
    private Text description;
    private Text nodeName;
    private Model input;
    private Model output = new Model();
    private Button btnNewButton;

    public RegistNodeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Group group = new Group(container, 0);
        group.setText(this.bundle_dialog_label.getString("dialog.regist_node.group.node_info_title"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label lblid = new Label((Composite)group, 0);
        lblid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblid.setText(this.bundle_dialog_label.getString("dialog.regist_node.facility_id_title"));
        this.facilityId = new Text((Composite)group, 2048);
        this.facilityId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)group, 0);
        this.btnNewButton = new Button((Composite)group, 32);
        this.btnNewButton.setText(this.bundle_dialog_label.getString("dialog.regist_node.node_replace_description"));
        Label lblFacilityName = new Label((Composite)group, 0);
        lblFacilityName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFacilityName.setText(this.bundle_dialog_label.getString("dialog.regist_node.facility_name_title"));
        this.facilityName = new Text((Composite)group, 2048);
        this.facilityName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(this.bundle_dialog_label.getString("dialog.regist_node.description_title"));
        this.description = new Text((Composite)group, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label_1 = new Label((Composite)group, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText(this.bundle_dialog_label.getString("dialog.regist_node.node_name_title"));
        this.nodeName = new Text((Composite)group, 2048);
        GridData gd_nodeName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_nodeName.widthHint = 66;
        this.nodeName.setLayoutData((Object)gd_nodeName);
        if (this.input != null) {
            if (this.input.getFacilityId() != null) {
                this.facilityId.setText(this.input.getFacilityId());
            }
            if (this.input.getFacilityName() != null) {
                this.facilityName.setText(this.input.getFacilityName());
            }
            if (this.input.getDescription() != null) {
                this.description.setText(this.input.getDescription());
            }
            if (this.input.getNodeName() != null) {
                this.nodeName.setText(this.input.getNodeName());
            }
            this.btnNewButton.setSelection(this.input.isReplaceNode());
        }
        ControlUtil.setRequired(new Control[]{this.facilityId, this.facilityName, this.nodeName});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 360);
    }

    protected void okPressed() {
        if (this.facilityId.getText() == "" || this.facilityName.getText() == "" || this.nodeName.getText() == "") {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.output = new Model();
        this.output.setFacilityId(this.facilityId.getText());
        this.output.setFacilityName(this.facilityName.getText());
        this.output.setDescription(this.description.getText());
        this.output.setNodeName(this.nodeName.getText());
        this.output.setReplaceNode(this.btnNewButton.getSelection());
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("regist_node"));
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
    }

    public Model getOutput() {
        return this.output;
    }

    public static class Model
    extends RegistNodeRequest
    implements Serializable {
        private static final long serialVersionUID = -2084659201305900110L;

        @Override
        public Model deepCopy() {
            return (Model)super.deepCopy();
        }
    }
}

