/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class RegistCommandDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Text txtJobId;
    private Text txtJobName;
    private Text txtArgument;
    private Text txtExecuteUser;
    private Combo cmbBehaviorInFailure;
    private Text txtRangeStart;
    private Text txtRangeEnd;
    private Text txtCommand;
    private Combo cmbScript;
    private Button rdoCommand;
    private Button rdoScript;
    private Button btnUploadScript;
    private TemplateJobUtil.TemplateJob input;
    private TemplateJobUtil.TemplateJob output;

    public RegistCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        int width;
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblJobId = new Label(container, 131072);
        lblJobId.setText(this.bundle_dialog_label.getString("dialog.regist_command.job_id_title"));
        this.txtJobId = new Text(container, 2048);
        this.txtJobId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJobName = new Label(container, 131072);
        lblJobName.setText(this.bundle_dialog_label.getString("dialog.regist_command.job_name_title"));
        this.txtJobName = new Text(container, 2048);
        this.txtJobName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label(container, 0);
        new Label(container, 0);
        Composite commandTypeComposite = new Composite(container, 0);
        GridLayout gl_commandTypeComposite = new GridLayout(3, false);
        commandTypeComposite.setLayout((Layout)gl_commandTypeComposite);
        commandTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.rdoCommand = new Button(commandTypeComposite, 16);
        this.rdoCommand.setText(this.bundle_dialog_label.getString("dialog.regist_command.radio.command_title"));
        this.rdoScript = new Button(commandTypeComposite, 16);
        this.rdoScript.setText(this.bundle_dialog_label.getString("dialog.regist_command.radio.script_title"));
        new Label(commandTypeComposite, 0);
        Group grpCommand = new Group(container, 0);
        grpCommand.setLayout((Layout)new GridLayout(2, false));
        grpCommand.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpCommand.setText(this.bundle_dialog_label.getString("dialog.regist_command.group.command_title"));
        Label lblCommand = new Label((Composite)grpCommand, 0);
        lblCommand.setText(this.bundle_dialog_label.getString("dialog.regist_command.command_title"));
        this.txtCommand = new Text((Composite)grpCommand, 2048);
        this.txtCommand.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpScript = new Group(container, 0);
        grpScript.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpScript.setLayout((Layout)new GridLayout(2, false));
        grpScript.setText(this.bundle_dialog_label.getString("dialog.regist_command.group.script_title"));
        Label lblScript = new Label((Composite)grpScript, 0);
        lblScript.setText(this.bundle_dialog_label.getString("dialog.regist_command.script_title"));
        this.cmbScript = new Combo((Composite)grpScript, 8);
        GridData gd_cmbScript = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbScript.widthHint = 100;
        this.cmbScript.setLayoutData((Object)gd_cmbScript);
        new Label((Composite)grpScript, 0);
        this.btnUploadScript = new Button((Composite)grpScript, 0);
        this.btnUploadScript.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.btnUploadScript.setText(this.bundle_dialog_label.getString("dialog.regist_command.button.upload_script_title"));
        this.btnUploadScript.setEnabled(false);
        new Label(container, 0);
        new Label(container, 0);
        Label lblArgument = new Label(container, 131072);
        lblArgument.setText(this.bundle_dialog_label.getString("dialog.regist_command.argument_title"));
        this.txtArgument = new Text(container, 2048);
        this.txtArgument.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblExecuteUser = new Label(container, 131072);
        lblExecuteUser.setText(this.bundle_dialog_label.getString("dialog.regist_command.execute_user_title"));
        this.txtExecuteUser = new Text(container, 2048);
        this.txtExecuteUser.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblBehavioreInFailure = new Label(container, 131072);
        lblBehavioreInFailure.setText(this.bundle_dialog_label.getString("dialog.regist_command.behavior_in_failure_title"));
        this.cmbBehaviorInFailure = new Combo(container, 8);
        GridData gd_cmbBehaviorInFailure = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbBehaviorInFailure.widthHint = 100;
        this.cmbBehaviorInFailure.setLayoutData((Object)gd_cmbBehaviorInFailure);
        Label lblSuccessReturnRange = new Label(container, 131072);
        lblSuccessReturnRange.setText(this.bundle_dialog_label.getString("dialog.regist_command.success_return_range_title"));
        Composite rangeComposite = new Composite(container, 0);
        GridLayout gl_rangeComposite = new GridLayout(3, false);
        gl_rangeComposite.marginWidth = 0;
        rangeComposite.setLayout((Layout)gl_rangeComposite);
        rangeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtRangeStart = new Text(rangeComposite, 2048);
        this.txtRangeStart.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label delimiter = new Label(rangeComposite, 0);
        delimiter.setText("-");
        this.txtRangeEnd = new Text(rangeComposite, 2048);
        this.txtRangeEnd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        container.layout(true);
        int rightColumnStart = this.txtJobId.getBounds().x;
        int leftColumnStart = lblCommand.getBounds().x;
        ((GridData)lblCommand.getLayoutData()).widthHint = width = rightColumnStart - leftColumnStart - 10;
        ((GridData)lblScript.getLayoutData()).widthHint = width;
        container.layout(true);
        Control[] requiredControls = new Control[]{this.txtJobId, this.txtJobName, this.txtCommand, this.cmbScript, this.txtExecuteUser, this.txtRangeStart, this.txtRangeEnd};
        ControlUtil.setRequired(requiredControls);
        Text[] texts = new Text[]{this.txtRangeStart, this.txtRangeEnd};
        ControlUtil.setDigitOnlyInput(texts);
        this.rdoCommand.setSelection(true);
        this.cmbScript.setEnabled(false);
        this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        try {
            for (String script : TemplateJobUtil.getTemplateScripts()) {
                this.cmbScript.add(script);
                this.cmbScript.setData(script, (Object)script);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (TemplateJobUtil.BehaviorInFailure behavior : TemplateJobUtil.BehaviorInFailure.values()) {
            this.cmbBehaviorInFailure.add(behavior.toString());
            this.cmbBehaviorInFailure.setData(behavior.toString(), (Object)behavior);
        }
        this.cmbBehaviorInFailure.select(0);
        if (this.input != null) {
            if (this.input.getJobId() != null && !this.input.getJobId().equals("")) {
                this.txtJobId.setText(this.input.getJobId());
            }
            if (this.input.getJobName() != null && !this.input.getJobName().equals("")) {
                this.txtJobName.setText(this.input.getJobName());
            }
            if (this.input.getCommandType() != null && this.input.getCommandType().equals((Object)TemplateJobUtil.CommandType.command)) {
                this.txtCommand.setEnabled(true);
                this.cmbScript.setEnabled(false);
                this.rdoCommand.setSelection(true);
                this.rdoScript.setSelection(false);
                if (this.input.getCommand() != null && !this.input.getCommand().equals("")) {
                    this.txtCommand.setText(this.input.getCommand());
                }
                if (this.txtCommand.getText().equals("")) {
                    this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            } else if (this.input.getCommandType() != null && this.input.getCommandType().equals((Object)TemplateJobUtil.CommandType.script)) {
                this.cmbScript.setEnabled(true);
                this.txtCommand.setEnabled(false);
                this.rdoCommand.setSelection(false);
                this.rdoScript.setSelection(true);
                if (this.input.getCommand() != null && !this.input.getCommand().equals("")) {
                    this.cmbScript.select(this.cmbScript.indexOf(this.input.getCommand()));
                }
                this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                if (this.cmbScript.getText().equals("") || this.cmbScript.indexOf(this.cmbScript.getText()) == -1) {
                    this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
            if (this.input.getArgument() != null && !this.input.getArgument().equals("")) {
                this.txtArgument.setText(this.input.getArgument());
            }
            if (this.input.getExecuteUser() != null && !this.input.getExecuteUser().equals("")) {
                this.txtExecuteUser.setText(this.input.getExecuteUser());
            }
            if (this.input.getBehaviorInFailure() != null) {
                this.cmbBehaviorInFailure.select(this.cmbBehaviorInFailure.indexOf(this.input.getBehaviorInFailure().toString()));
            }
            if (this.input.getSuccessRangeStartValue() != null) {
                this.txtRangeStart.setText(this.input.getSuccessRangeStartValue().toString());
            }
            if (this.input.getSuccessRangeEndValue() != null) {
                this.txtRangeEnd.setText(this.input.getSuccessRangeEndValue().toString());
            }
        }
        this.rdoCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistCommandDialog.this.txtCommand.setEnabled(true);
                RegistCommandDialog.this.cmbScript.setEnabled(false);
                if (RegistCommandDialog.this.txtCommand.getText().equals("")) {
                    RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        });
        this.rdoScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RegistCommandDialog.this.cmbScript.getItemCount() < 1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)RegistCommandDialog.this.bundle_messages.getString("dialogs.common_scripts_do_not_exist"));
                    RegistCommandDialog.this.rdoScript.setSelection(false);
                    RegistCommandDialog.this.rdoCommand.setSelection(true);
                    return;
                }
                RegistCommandDialog.this.cmbScript.setEnabled(true);
                RegistCommandDialog.this.txtCommand.setEnabled(false);
                RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                if (RegistCommandDialog.this.cmbScript.getText().equals("") || RegistCommandDialog.this.cmbScript.indexOf(RegistCommandDialog.this.cmbScript.getText()) == -1) {
                    RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(480, 640);
    }

    protected void okPressed() {
        if (this.txtJobId.getText().equals("") || this.txtJobName.getText().equals("") || !this.rdoCommand.getSelection() && !this.rdoScript.getSelection() || this.rdoCommand.getSelection() && this.txtCommand.getText().equals("") || this.rdoScript.getSelection() && this.cmbScript.getText().equals("") || this.txtExecuteUser.getText().equals("") || this.cmbBehaviorInFailure.getText().equals("") || this.txtRangeStart.getText().equals("") || this.txtRangeEnd.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        if (this.rdoScript.getSelection() && this.cmbScript.getData(this.cmbScript.getText()) == null) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.invalid_parameter_exists"));
            return;
        }
        try {
            if (Integer.parseInt(this.txtRangeStart.getText()) > Integer.parseInt(this.txtRangeEnd.getText())) {
                String label = this.bundle_dialog_label.getString("dialog.regist_command.success_return_range_title");
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.invalid_digit_order", new Object[]{"\u300c" + label + "(1)\u300d", "\u300c" + label + "(2)\u300d"}));
                return;
            }
        }
        catch (NumberFormatException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.invalid_parameter_exists"));
            return;
        }
        this.output = new TemplateJobUtil.TemplateJob();
        this.output.setJobId(this.txtJobId.getText());
        this.output.setJobName(this.txtJobName.getText());
        if (this.rdoCommand.getSelection()) {
            this.output.setCommandType(TemplateJobUtil.CommandType.command);
            this.output.setCommand(this.txtCommand.getText());
        } else if (this.rdoScript.getSelection()) {
            this.output.setCommandType(TemplateJobUtil.CommandType.script);
            this.output.setCommand((String)this.cmbScript.getData(this.cmbScript.getText()));
        } else {
            throw new IllegalStateException();
        }
        if (!this.txtArgument.getText().equals("")) {
            this.output.setArgument(this.txtArgument.getText());
        }
        this.output.setExecuteUser(this.txtExecuteUser.getText());
        this.output.setBehaviorInFailure((TemplateJobUtil.BehaviorInFailure)((Object)this.cmbBehaviorInFailure.getData(this.cmbBehaviorInFailure.getText())));
        try {
            this.output.setSuccessRangeStartValue(Integer.parseInt(this.txtRangeStart.getText()));
            this.output.setSuccessRangeEndValue(Integer.parseInt(this.txtRangeEnd.getText()));
        }
        catch (NumberFormatException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.invalid_parameter_exists"));
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("regist_command"));
    }

    public void setInput(TemplateJobUtil.TemplateJob input) {
        this.input = input;
    }

    public TemplateJobUtil.TemplateJob getOutput() {
        return this.output;
    }
}

