/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.AccessKey;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegistAccountDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Model input = new Model();
    private Model output = new Model();
    private Mode mode;
    private Type type;
    private String[] userIdList = new String[0];
    private ICategory category;
    private Text txtCloudUserId;
    private Text txtCloudUserName;
    private Text txtDescription;
    private Text textAccessKey;
    private Text textSecretKey;
    private Combo comboUserId;

    public RegistAccountDialog(Shell parentShell, Mode mode, Type type) {
        super(parentShell);
        this.mode = mode;
        this.type = type;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_composite.heightHint = 411;
        gd_composite.widthHint = 217;
        composite.setLayoutData((Object)gd_composite);
        Group group_1 = new Group(composite, 0);
        group_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        switch (this.type) {
            case account: {
                group_1.setText(this.bundle_dialog_label.getString("dialog.regist_account.group.account_info_title"));
                break;
            }
            case user: {
                group_1.setText(this.bundle_dialog_label.getString("dialog.regist_account.group.user_info_title"));
            }
        }
        GridLayout gl_group_1 = new GridLayout(2, false);
        gl_group_1.horizontalSpacing = 16;
        group_1.setLayout((Layout)gl_group_1);
        Label lblCloudType = new Label((Composite)group_1, 131072);
        lblCloudType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCloudType.setText(this.bundle_dialog_label.getString("dialog.regist_account.cloud_id_title"));
        Text textCloudType = new Text((Composite)group_1, 2048);
        textCloudType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        textCloudType.setEditable(false);
        new Label((Composite)group_1, 0);
        new Label((Composite)group_1, 0);
        Label lblSecurityGroupName = new Label((Composite)group_1, 131072);
        lblSecurityGroupName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSecurityGroupName.setText(this.bundle_dialog_label.getString("dialog.regist_account.cloud_user_id_title"));
        this.txtCloudUserId = new Text((Composite)group_1, 2048);
        this.txtCloudUserId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)group_1, 0);
        new Label((Composite)group_1, 0);
        Label lblDescription = new Label((Composite)group_1, 131072);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.bundle_dialog_label.getString("dialog.regist_account.cloud_user_name_title"));
        this.txtCloudUserName = new Text((Composite)group_1, 2048);
        this.txtCloudUserName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)group_1, 0);
        new Label((Composite)group_1, 0);
        Label lblUserid = new Label((Composite)group_1, 131072);
        lblUserid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserid.setText(this.bundle_dialog_label.getString("dialog.regist_account.description_title"));
        this.txtDescription = new Text((Composite)group_1, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group group_2 = new Group(composite, 0);
        group_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group_2.setText(this.bundle_dialog_label.getString("dialog.regist_account.group.security_property_title"));
        GridLayout gl_group_2 = new GridLayout(2, false);
        gl_group_2.horizontalSpacing = 16;
        group_2.setLayout((Layout)gl_group_2);
        Label lblAccessKey = new Label((Composite)group_2, 131072);
        lblAccessKey.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAccessKey.setText(this.bundle_dialog_label.getString("dialog.regist_account.access_key_title"));
        ((GridData)lblAccessKey.getLayoutData()).widthHint = 106;
        this.textAccessKey = new Text((Composite)group_2, 2048);
        this.textAccessKey.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        new Label((Composite)group_2, 0);
        new Label((Composite)group_2, 0);
        Label lblSecretKey = new Label((Composite)group_2, 131072);
        lblSecretKey.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSecretKey.setSize(76, 18);
        lblSecretKey.setText(this.bundle_dialog_label.getString("dialog.regist_account.secret_key_title"));
        this.textSecretKey = new Text((Composite)group_2, 0x400800);
        this.textSecretKey.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textSecretKey.setSize(765, 24);
        new Label((Composite)group_2, 0);
        new Label((Composite)group_2, 0);
        Label lblUserId = new Label((Composite)group_2, 131072);
        lblUserId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserId.setSize(51, 18);
        lblUserId.setText(this.bundle_dialog_label.getString("dialog.regist_account.assign_user_id_title"));
        this.comboUserId = new Combo((Composite)group_2, 8);
        GridData gd_comboUserId = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_comboUserId.widthHint = 100;
        this.comboUserId.setLayoutData((Object)gd_comboUserId);
        this.comboUserId.setSize(832, 26);
        switch (this.mode) {
            case regist: {
                textCloudType.setText(this.category.getName());
                if (this.userIdList.length == 0) {
                    this.comboUserId.setEnabled(false);
                    break;
                }
                for (String p : this.userIdList) {
                    this.comboUserId.add(p);
                }
                this.comboUserId.select(0);
                break;
            }
            case modify: {
                this.txtCloudUserId.setEditable(false);
                textCloudType.setText(this.input.category.getName());
                this.txtCloudUserId.setText(this.input.id);
                this.txtCloudUserName.setText(this.input.name);
                if (this.input.description != null) {
                    this.txtDescription.setText(this.input.description);
                }
                if (this.input.key.getAccessKey() != null) {
                    this.textAccessKey.setText(this.input.key.getAccessKey());
                }
                if (this.input.key.getSecretKey() != null) {
                    this.textSecretKey.setText(this.input.key.getSecretKey());
                }
                this.comboUserId.add(this.input.hinemosUserId, 0);
                this.comboUserId.select(0);
                this.comboUserId.setEnabled(false);
            }
        }
        ControlUtil.setRequired(new Control[]{this.txtCloudUserId, this.txtCloudUserName});
        area.layout();
        Label[] labels = new Label[]{lblCloudType, lblSecurityGroupName, lblDescription, lblUserid, lblAccessKey, lblSecretKey, lblUserId};
        int maxWidth = 0;
        for (Label l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Label l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        group_1.layout(true);
        group_2.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 520);
    }

    protected void okPressed() {
        if ("".equals(this.txtCloudUserId.getText()) || "".equals(this.txtCloudUserName.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.output.category = this.category;
        this.output.id = this.txtCloudUserId.getText();
        this.output.name = this.txtCloudUserName.getText();
        this.output.description = this.txtDescription.getText();
        this.output.key.setAccessKey(this.textAccessKey.getText());
        this.output.key.setSecretKey(this.textSecretKey.getText());
        this.output.hinemosUserId = this.comboUserId.getText();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        switch (this.type) {
            case account: {
                newShell.setText(this.bundle_dialog_name.getString("regist_account"));
                break;
            }
            case user: {
                newShell.setText(this.bundle_dialog_name.getString("regist_user"));
            }
        }
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
    }

    public void setUserIdList(String[] userIdList) {
        this.userIdList = userIdList;
    }

    public void setCategory(ICategory category) {
        this.category = category;
    }

    public Model getOutput() {
        return this.output;
    }

    public static enum Type {
        account,
        user;

    }

    public static enum Mode {
        regist,
        modify;

    }

    public static class Model {
        public String id;
        public String name;
        public AccessKey key = new AccessKey();
        public String description;
        public String hinemosUserId;
        public ICategory category;
    }
}

