/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.VolumeProvider;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class DetachInstanceDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private IInstance instance;
    private List<IStorage> volumes = new ArrayList<IStorage>();
    private Table table;
    private TableViewer tableViewer;
    private Text availabilityZone;
    private Text instanceName;

    public DetachInstanceDialog(Shell parentShell, IInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblAvailabilityZone = new Label(container, 0);
        lblAvailabilityZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailabilityZone.setText(this.bundle_dialog_label.getString("dialog.detach_instance.availability_zone_title"));
        this.availabilityZone = new Text(container, 2056);
        this.availabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.availabilityZone.setText(this.instance.getAvailabilityZone());
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.bundle_dialog_label.getString("dialog.detach_instance.instance_title"));
        this.instanceName = new Text(container, 2056);
        this.instanceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.instanceName.setText(this.instance.getInstanceId());
        this.table = new Table(container, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnVolumeId = new TableColumn(this.table, 0);
        tblclmnVolumeId.setWidth(90);
        tblclmnVolumeId.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.volume_id"));
        TableColumn tableColumn_6 = new TableColumn(this.table, 0);
        tableColumn_6.setWidth(70);
        tableColumn_6.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.volume_name"));
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(70);
        tableColumn.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.type"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(70);
        tableColumn_1.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.device"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(70);
        tableColumn_2.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.snapshot_id"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(70);
        tableColumn_3.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.size"));
        TableColumn tableColumn_4 = new TableColumn(this.table, 0);
        tableColumn_4.setWidth(70);
        tableColumn_4.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.volume_type"));
        TableColumn tableColumn_5 = new TableColumn(this.table, 0);
        tableColumn_5.setWidth(70);
        tableColumn_5.setText(this.bundle_dialog_label.getString("dialog.detach_instance.column.iops"));
        this.tableViewer = new TableViewer(this.table);
        VolumeProvider vp = new VolumeProvider();
        this.tableViewer.setContentProvider((IContentProvider)vp.getVolumeContentProvider());
        this.instance.update();
        this.instance.getRegion().getStorageRoot().update();
        ArrayList<IStorage> storages = new ArrayList<IStorage>();
        block0: for (IStorage s : this.instance.getRegion().getStorageRoot().getStorages()) {
            for (BlockDeviceMapping d : this.instance.getBlockDeviceMappings()) {
                if (!d.getVolumeId().equals(s.getStorageId())) continue;
                storages.add(s);
                continue block0;
            }
        }
        this.tableViewer.setInput(storages);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)vp.getVolumeLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetachInstanceDialog.this.volumes.clear();
                for (TableItem ti : DetachInstanceDialog.this.table.getSelection()) {
                    DetachInstanceDialog.this.volumes.add((IStorage)ti.getData());
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.volumes.isEmpty()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        Pattern p = Pattern.compile("/dev/sda.*");
        Boolean b = false;
        for (IStorage vol : this.volumes) {
            if (!p.matcher(vol.getStorageAttachment().getDevice()).find()) continue;
            b = true;
            break;
        }
        if (b.booleanValue()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.can_not_root_volume"));
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("detach_storage"));
    }

    public List<String> getVolumes() {
        ArrayList<String> storageIds = new ArrayList<String>();
        for (IStorage storage : this.volumes) {
            storageIds.add(storage.getStorageId());
        }
        return storageIds;
    }
}

