/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.CreateTemplateRequest;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.SelectAMIDialog2;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateTemplateDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Shell shell;
    private Combo region;
    private Text templateId;
    private Text templateName;
    private Text ami;
    private Combo launchJobId;
    private Combo startJobId;
    private Combo stopJobId;
    private CloudResourceProvider provider;
    private IDialogBehavior behavior = new DialogBehavior();
    private CreateTemplateRequest output = new CreateTemplateRequest();

    public CreateTemplateDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 4);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(3, false);
        gl_container.verticalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(4, 4, true, false);
        gd_container.verticalAlignment = 4;
        gd_container.horizontalAlignment = 4;
        container.setLayoutData((Object)gd_container);
        Label lblRegion = new Label(container, 131072);
        lblRegion.setText(this.bundle_dialog_label.getString("dialog.create_template.region_title"));
        this.region = new Combo(container, 8);
        this.region.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblTemplateId = new Label(container, 131072);
        lblTemplateId.setText(this.bundle_dialog_label.getString("dialog.create_template.template_id_title"));
        this.templateId = new Text(container, 2048);
        this.templateId.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblTemplateName = new Label(container, 131072);
        lblTemplateName.setText(this.bundle_dialog_label.getString("dialog.create_template.template_name_title"));
        this.templateName = new Text(container, 2048);
        this.templateName.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblAmi = new Label(container, 131072);
        lblAmi.setText(this.bundle_dialog_label.getString("dialog.create_template.ami_title"));
        this.ami = new Text(container, 2056);
        this.ami.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button btnSelectAMI = new Button(container, 0);
        btnSelectAMI.setText(this.bundle_dialog_label.getString("dialog.create_template.button.select_ami_title"));
        btnSelectAMI.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Label lblLaunchJobId = new Label(container, 131072);
        lblLaunchJobId.setText(this.bundle_dialog_label.getString("dialog.create_template.launch_job_id_title"));
        this.launchJobId = new Combo(container, 8);
        GridData gd_launchJobId = new GridData(4, 4, true, true, 2, 1);
        gd_launchJobId.widthHint = 100;
        this.launchJobId.setLayoutData((Object)gd_launchJobId);
        Label lblStartJobId = new Label(container, 131072);
        lblStartJobId.setText(this.bundle_dialog_label.getString("dialog.create_template.start_job_id_title"));
        this.startJobId = new Combo(container, 8);
        GridData gd_startJobId = new GridData(4, 4, true, true, 2, 1);
        gd_startJobId.widthHint = 100;
        this.startJobId.setLayoutData((Object)gd_startJobId);
        Label lblStopJobId = new Label(container, 131072);
        lblStopJobId.setText(this.bundle_dialog_label.getString("dialog.create_template.stop_job_id_title"));
        this.stopJobId = new Combo(container, 8);
        GridData gd_stopJobId = new GridData(4, 4, true, true, 2, 1);
        gd_stopJobId.widthHint = 100;
        this.stopJobId.setLayoutData((Object)gd_stopJobId);
        this.behavior.setupRegion(this.region);
        this.behavior.setupTemplateId(this.templateId);
        this.behavior.setupTemplateName(this.templateName);
        this.behavior.setupAmi(this.ami, btnSelectAMI);
        this.behavior.setupLaunchJobId(this.launchJobId);
        this.behavior.setupStartJobId(this.startJobId);
        this.behavior.setupStopJobId(this.stopJobId);
        this.region.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTemplateDialog.this.ami.setText("");
                CreateTemplateDialog.this.ami.setData(null);
            }
        });
        btnSelectAMI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectAMIDialog2 dialog = new SelectAMIDialog2(CreateTemplateDialog.this.shell);
                dialog.setCloudInfoProvider(CreateTemplateDialog.this.provider);
                dialog.setRegion((String)CreateTemplateDialog.this.region.getData(CreateTemplateDialog.this.region.getText()));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Image image = dialog.getOutput();
                    CreateTemplateDialog.this.ami.setText("(" + image.getImageId() + ") " + image.getName());
                    CreateTemplateDialog.this.ami.setData((Object)image);
                }
            }
        });
        ControlUtil.setRequired(new Control[]{this.templateId, this.templateName, this.ami});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.templateId.getText() == "" || this.templateName.getText() == "" || this.region.getText() == "" || this.ami.getText() == "") {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.output.setRegion((String)this.region.getData(this.region.getText()));
        this.output.setTemplateId(this.templateId.getText());
        this.output.setTemplateName(this.templateName.getText().equals("") ? null : this.templateName.getText());
        this.output.setImageId(((Image)this.ami.getData()).getImageId());
        this.output.setLaunchJobId(this.launchJobId.getText().equals("") ? null : (String)this.launchJobId.getData(this.launchJobId.getText()));
        this.output.setStartJobId(this.startJobId.getText().equals("") ? null : (String)this.startJobId.getData(this.startJobId.getText()));
        this.output.setStopJobId(this.stopJobId.getText().equals("") ? null : (String)this.stopJobId.getData(this.stopJobId.getText()));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("create_template"));
    }

    public CreateTemplateRequest getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setupRegion(Combo region) {
        }

        @Override
        public void setupTemplateId(Text templateId) {
        }

        @Override
        public void setupTemplateName(Text templateName) {
        }

        @Override
        public void setupAmi(Text ami, Button selectAmi) {
        }

        @Override
        public void setupLaunchJobId(Combo launchJobId) {
        }

        @Override
        public void setupStartJobId(Combo startJobId) {
        }

        @Override
        public void setupStopJobId(Combo stopJobId) {
        }
    }

    public static interface IDialogBehavior {
        public void setupRegion(Combo var1);

        public void setupTemplateId(Text var1);

        public void setupTemplateName(Text var1);

        public void setupAmi(Text var1, Button var2);

        public void setupLaunchJobId(Combo var1);

        public void setupStartJobId(Combo var1);

        public void setupStopJobId(Combo var1);
    }
}

