/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Snapshot;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class CreateStorageBehavior
implements CreateStorageDialog.IDialogBehavior {
    private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private CreateStorageDialog.Model input;
    private CloudResourceProvider provider;
    private Combo comboRegion;
    private Combo comboAvailabilityZone;
    private Combo comboSnapshot;

    @Override
    public void setInput(CreateStorageDialog.Model input) {
        this.input = input;
        if (this.comboRegion == null) {
            return;
        }
        if (this.input.region != null) {
            for (String item : this.comboRegion.getItems()) {
                if (!this.comboRegion.getData(item).equals(this.input.region)) continue;
                this.comboRegion.setText(item);
                break;
            }
        }
    }

    @Override
    public void setProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setupVolumeName(Text volumeName) {
    }

    @Override
    public void setupSize(Text size, Combo unit) {
    }

    @Override
    public void setupRegion(Combo comboRegion) {
        this.comboRegion = comboRegion;
        comboRegion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String region = (String)CreateStorageBehavior.this.comboRegion.getData(CreateStorageBehavior.this.comboRegion.getText());
                if (CreateStorageBehavior.this.comboAvailabilityZone != null) {
                    List<AvailabilityZone> avs = CreateStorageBehavior.this.provider.getAvailabilityZones(region);
                    CreateStorageBehavior.this.comboAvailabilityZone.removeAll();
                    for (AvailabilityZone name : avs) {
                        CreateStorageBehavior.this.comboAvailabilityZone.add(name.getZoneName());
                    }
                    if (!avs.isEmpty()) {
                        CreateStorageBehavior.this.comboAvailabilityZone.select(0);
                    }
                }
                if (CreateStorageBehavior.this.comboSnapshot != null) {
                    CreateStorageBehavior.this.comboSnapshot.removeAll();
                    CreateStorageBehavior.this.comboSnapshot.add("--- No Snapshot ---");
                    CreateStorageBehavior.this.comboSnapshot.select(0);
                }
            }
        });
        for (String regionName : this.provider.getAllRegion()) {
            String regionLocaleName = this.bundle_region.getString(regionName);
            comboRegion.add(regionLocaleName);
            comboRegion.setData(regionLocaleName, (Object)regionName);
        }
        if (this.input != null && this.input.region != null) {
            for (String item : comboRegion.getItems()) {
                if (!comboRegion.getData(item).equals(this.input.region)) continue;
                comboRegion.setText(item);
                break;
            }
        } else {
            comboRegion.select(0);
        }
    }

    @Override
    public void setupAvailabilityZone(Combo comboAvailabilityZone) {
        this.comboAvailabilityZone = comboAvailabilityZone;
        if (this.comboRegion != null) {
            String region = (String)this.comboRegion.getData(this.comboRegion.getText());
            List<AvailabilityZone> avs = this.provider.getAvailabilityZones(region);
            comboAvailabilityZone.removeAll();
            for (AvailabilityZone name : avs) {
                comboAvailabilityZone.add(name.getZoneName());
            }
            if (!avs.isEmpty()) {
                comboAvailabilityZone.select(0);
            }
        }
    }

    @Override
    public void setupSnapshot(Combo comboSnapshot) {
        this.comboSnapshot = comboSnapshot;
        comboSnapshot.add("--- No Snapshot ---");
        comboSnapshot.select(0);
        comboSnapshot.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (CreateStorageBehavior.this.comboSnapshot.getItemCount() <= 1) {
                    List<Snapshot> snapshots = CreateStorageBehavior.this.provider.getSnapshots((String)CreateStorageBehavior.this.comboRegion.getData(CreateStorageBehavior.this.comboRegion.getText()), Arrays.asList(new Filter[0]));
                    for (Snapshot s : snapshots) {
                        String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
                        CreateStorageBehavior.this.comboSnapshot.add(snapshotName);
                        CreateStorageBehavior.this.comboSnapshot.setData(snapshotName, (Object)s);
                    }
                }
            }
        });
    }

    @Override
    public void setupVolumeType(Combo volumeType) {
        for (String volumeTypeName : this.provider.getAllVolumeType()) {
            String volumeTypeLocaleName = this.bundle_volume_type.getString(volumeTypeName);
            volumeType.add(volumeTypeLocaleName);
            volumeType.setData(volumeTypeLocaleName, (Object)volumeTypeName);
        }
        volumeType.select(0);
    }

    @Override
    public void setupIops(Combo Iops) {
    }
}

