/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.CreateBillingAlarmRequest;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.aws.presenter.ModifyBillingAlarmRequest;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ChargeAlertDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private Text txtAlarmId;
    private Text txtAlarmName;
    private Text txtThresholdInfoLimit;
    private Text txtThresholdWarnLimit;
    private Text txtDescription;
    private Button btnValidFlg;
    private ModifyBillingAlarmRequest modifyRequest;
    private CreateBillingAlarmRequest createRequest;
    private IBillingAlarm input = null;
    private List<NotifyRelationInfo> notifyRelationInfoList;
    private NotifyIdListComposite notifyInfo = null;
    private CloudResourceProvider provider;
    private Combo cmbTarget;

    public ChargeAlertDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblAlarmId = new Label(container, 0);
        lblAlarmId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAlarmId.setAlignment(131072);
        lblAlarmId.setText(this.bundle_dialog_label.getString("dialog.charge_alert.alarm_id_title"));
        new Label(container, 0);
        this.txtAlarmId = new Text(container, 2048);
        this.txtAlarmId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAlarmName = new Label(container, 0);
        lblAlarmName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAlarmName.setAlignment(131072);
        lblAlarmName.setText(this.bundle_dialog_label.getString("dialog.charge_alert.alarm_name_title"));
        new Label(container, 0);
        this.txtAlarmName = new Text(container, 2048);
        this.txtAlarmName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(container, 0);
        lblDescription.setAlignment(131072);
        lblDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.bundle_dialog_label.getString("dialog.charge_alert.description_title"));
        new Label(container, 0);
        this.txtDescription = new Text(container, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_1 = new Label(container, 0);
        GridData gd_lblNewLabel_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_1.widthHint = 84;
        lblNewLabel_1.setLayoutData((Object)gd_lblNewLabel_1);
        lblNewLabel_1.setAlignment(131072);
        lblNewLabel_1.setText(this.bundle_dialog_label.getString("dialog.charge_alert.target_title"));
        new Label(container, 0);
        this.cmbTarget = new Combo(container, 8);
        GridData gd_cmbTarget = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbTarget.widthHint = 426;
        this.cmbTarget.setLayoutData((Object)gd_cmbTarget);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(4, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        group.setText(this.bundle_dialog_label.getString("dialog.charge_alert.group.judge_title"));
        Label lblInfoThreshold = new Label((Composite)group, 0);
        lblInfoThreshold.setAlignment(131072);
        GridData gd_lblInfoThreshold = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblInfoThreshold.widthHint = 77;
        lblInfoThreshold.setLayoutData((Object)gd_lblInfoThreshold);
        lblInfoThreshold.setBackground(SWTResourceManager.getColor(5));
        lblInfoThreshold.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_info_title"));
        new Label((Composite)group, 0);
        this.txtThresholdInfoLimit = new Text((Composite)group, 133120);
        this.txtThresholdInfoLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = ChargeAlertDialog.this.txtThresholdInfoLimit.getText().substring(0, e.start) + e.text + ChargeAlertDialog.this.txtThresholdInfoLimit.getText().substring(e.start);
                    if (t.length() != 0) {
                        Double.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        GridData gd_txtThresholdInfoLimit = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtThresholdInfoLimit.widthHint = 50;
        this.txtThresholdInfoLimit.setLayoutData((Object)gd_txtThresholdInfoLimit);
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_info_description"));
        Label lblWarnThreshold = new Label((Composite)group, 0);
        lblWarnThreshold.setAlignment(131072);
        lblWarnThreshold.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblWarnThreshold.setBackground(SWTResourceManager.getColor(7));
        lblWarnThreshold.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_warn_title"));
        new Label((Composite)group, 0);
        this.txtThresholdWarnLimit = new Text((Composite)group, 133120);
        this.txtThresholdWarnLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = ChargeAlertDialog.this.txtThresholdWarnLimit.getText().substring(0, e.start) + e.text + ChargeAlertDialog.this.txtThresholdWarnLimit.getText().substring(e.start);
                    if (t.length() != 0) {
                        Double.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        GridData gd_txtThresholdWarnLimit = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtThresholdWarnLimit.widthHint = 50;
        this.txtThresholdWarnLimit.setLayoutData((Object)gd_txtThresholdWarnLimit);
        Label label_1 = new Label((Composite)group, 0);
        GridData gd_label_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_label_1.widthHint = 327;
        label_1.setLayoutData((Object)gd_label_1);
        label_1.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_warn_description"));
        Label lblAlert = new Label((Composite)group, 0);
        lblAlert.setAlignment(131072);
        lblAlert.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAlert.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_error_title"));
        lblAlert.setBackground(SWTResourceManager.getColor(3));
        new Label((Composite)group, 0);
        Label lblNewLabel = new Label((Composite)group, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblNewLabel.setText(this.bundle_dialog_label.getString("dialog.charge_alert.threshold_error_description"));
        Group group_1 = new Group(container, 0);
        group_1.setLayout((Layout)new GridLayout(1, false));
        group_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        group_1.setText(this.bundle_dialog_label.getString("dialog.charge_alert.group.notify_title"));
        this.notifyInfo = new NotifyIdListComposite((Composite)group_1, 0, true);
        this.notifyInfo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnValidFlg = new Button(container, 32);
        this.btnValidFlg.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnValidFlg.setText(this.bundle_dialog_label.getString("dialog.charge_alert.enabling_description"));
        this.btnValidFlg.setSelection(true);
        for (String target : this.provider.getAllServiceName()) {
            if ("Total".equals(target)) {
                this.cmbTarget.add(this.bundle_view_label.getString("view.billing_alarm.monitor_service.total"));
                continue;
            }
            this.cmbTarget.add(target);
        }
        if (this.cmbTarget.getItemCount() != 0) {
            this.cmbTarget.select(0);
        }
        ControlUtil.setRequired(new Control[]{this.txtAlarmId, this.txtAlarmName, this.txtDescription, this.txtThresholdInfoLimit, this.txtThresholdWarnLimit});
        if (this.input != null) {
            this.txtAlarmId.setText(this.input.getAlarmId());
            this.txtAlarmId.setEditable(false);
            this.txtAlarmName.setText(this.input.getAlarmName());
            this.txtDescription.setText(this.input.getDescription());
            for (String item : this.cmbTarget.getItems()) {
                if (!item.equals(this.input.getTarget())) continue;
                this.cmbTarget.setText(this.input.getTarget());
                break;
            }
            this.txtThresholdInfoLimit.setText(String.valueOf(this.input.getThresholdInfoLimit()));
            this.txtThresholdWarnLimit.setText(String.valueOf(this.input.getThresholdWarnLimit()));
            this.notifyInfo.setNotify(this.input.getNotifyRelationInfos());
            this.btnValidFlg.setSelection(this.input.getValidFlg().booleanValue());
            this.notifyInfo.setNotify(this.input.getNotifyRelationInfos());
        }
        return container;
    }

    public List<NotifyRelationInfo> getNotifyRelationInfoList() {
        return this.notifyRelationInfoList;
    }

    protected void okPressed() {
        if ("".equals(this.txtAlarmId.getText()) || "".equals(this.txtAlarmName.getText()) || "".equals(this.txtThresholdInfoLimit.getText()) || "".equals(this.txtThresholdWarnLimit.getText()) || "".equals(this.txtDescription.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        Double infoLimit = null;
        Double warnLimit = null;
        try {
            infoLimit = Double.valueOf(this.txtThresholdInfoLimit.getText());
            warnLimit = Double.valueOf(this.txtThresholdWarnLimit.getText());
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.billing_alarm.message.invalid_limit"));
            return;
        }
        this.modifyRequest = new ModifyBillingAlarmRequest();
        this.modifyRequest.setAlarmName(this.txtAlarmName.getText());
        this.modifyRequest.setDescription(this.txtDescription.getText());
        this.modifyRequest.setTarget(this.bundle_view_label.getString("view.billing_alarm.monitor_service.total").equals(this.cmbTarget.getText()) ? "Total" : this.cmbTarget.getText());
        this.modifyRequest.setThresholdInfoLimit(Double.valueOf(this.txtThresholdInfoLimit.getText()));
        this.modifyRequest.setThresholdWarnLimit(Double.valueOf(this.txtThresholdWarnLimit.getText()));
        this.modifyRequest.setValidFlg(this.btnValidFlg.getSelection());
        String notifyGroupId = NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_BILLING", (String)this.txtAlarmId.getText());
        this.notifyInfo.setNotifyGroupId(notifyGroupId);
        this.modifyRequest.setNotifyRelationInfos(this.notifyInfo.getNotify());
        this.createRequest = new CreateBillingAlarmRequest();
        this.createRequest.setAlarmId(this.txtAlarmId.getText());
        this.createRequest.setAlarmName(this.txtAlarmName.getText());
        this.createRequest.setDescription(this.txtDescription.getText());
        this.createRequest.setTarget(this.bundle_view_label.getString("view.billing_alarm.monitor_service.total").equals(this.cmbTarget.getText()) ? "Total" : this.cmbTarget.getText());
        this.createRequest.setThresholdInfoLimit(infoLimit);
        this.createRequest.setThresholdWarnLimit(warnLimit);
        this.createRequest.setValidFlg(this.btnValidFlg.getSelection());
        this.notifyInfo.setNotifyGroupId(notifyGroupId);
        this.createRequest.setNotifyRelationInfos(this.notifyInfo.getNotify());
        this.setReturnCode(0);
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(560, 550);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("charge_alert"));
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public ModifyBillingAlarmRequest getModifyRequest() {
        return this.modifyRequest;
    }

    public CreateBillingAlarmRequest getCreateRequest() {
        return this.createRequest;
    }

    public void setInput(IBillingAlarm input) {
        this.input = input;
    }
}

