/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.IIpPermission;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ParameterManager;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AddRuleDialog
extends Dialog {
    private static final int INNER_WIDTH = 596;
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private ParameterManager protocolList = ParameterManager.getInstance("service_for_ip_permission");
    private ParameterManager bundle_icmp = ParameterManager.getInstance("icmp_list");
    private Text protocol;
    private Text fromPort;
    private Text toPort;
    private Text source;
    private String returnProtocol;
    private String returnSecurityGroupId;
    private String returnUserId;
    private String returnGroupName;
    private String returnIpRange;
    private Integer returnFromPort;
    private Integer returnToPort;
    private IIpPermission ip;
    private Label lblPort;
    private Label lblPort2;
    private Combo template;
    private Combo icmp1;
    private Combo icmp2;
    private Map<String, String> serviceMap = new HashMap<String, String>();
    private Label lblService;
    private Label lblType;
    private Label lblCode;
    private Label lblSource;
    private Label lblSource2;

    public AddRuleDialog(Shell parentShell) {
        super(parentShell);
    }

    public AddRuleDialog(Shell parentShell, IIpPermission ip) {
        super(parentShell);
        this.ip = ip;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setBackground(SWTResourceManager.getColor(22));
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        Label lblTemp = new Label((Composite)group, 0);
        lblTemp.setText("");
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(this.bundle_dialog_label.getString("dialog.add_rule.service_title"));
        tmpList.add(this.bundle_dialog_label.getString("dialog.add_rule.port_title"));
        tmpList.add(this.bundle_dialog_label.getString("dialog.add_rule.source_title"));
        tmpList.add(this.bundle_dialog_label.getString("dialog.add_rule.type_title"));
        tmpList.add(this.bundle_dialog_label.getString("dialog.add_rule.code_title"));
        Integer tmpWidth = 0;
        for (String str : tmpList) {
            lblTemp.setText(str);
            lblTemp.getParent().layout();
            if (tmpWidth >= lblTemp.getSize().x) continue;
            tmpWidth = lblTemp.getSize().x;
        }
        lblTemp.setText(this.bundle_dialog_label.getString("dialog.add_rule.port_bridge"));
        lblTemp.getParent().layout();
        Integer portBridgeWidth = lblTemp.getSize().x;
        Integer portWidth = (596 - tmpWidth - portBridgeWidth - 30) / 2;
        this.lblService = new Label(container, 131072);
        this.lblService.setBounds(0, 3, tmpWidth.intValue(), 19);
        this.lblService.setAlignment(131072);
        this.lblService.setText(this.bundle_dialog_label.getString("dialog.add_rule.service_title"));
        this.template = new Combo(container, 0);
        this.template.setBounds(tmpWidth + 10, 0, 596 - tmpWidth - 10, 25);
        this.lblPort = new Label(container, 0);
        this.lblPort.setBounds(0, 3, tmpWidth.intValue(), 19);
        this.lblPort.setAlignment(131072);
        this.lblPort.setText(this.bundle_dialog_label.getString("dialog.add_rule.port_title"));
        this.fromPort = new Text(container, 2048);
        this.fromPort.setBounds(tmpWidth + 10, 0, portWidth.intValue(), 25);
        this.fromPort.setBackground(SWTResourceManager.getColor(20));
        this.fromPort.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.keyCode >= 48 && e.keyCode <= 57 && e.stateMask == 0 || e.keyCode >= 0x1000030 && e.keyCode <= 16777273 && e.stateMask == 0 || AddRuleDialog.checkKey(e.keyCode))) {
                    e.doit = false;
                }
            }
        });
        this.lblPort2 = new Label(container, 0);
        this.lblPort2.setBounds(tmpWidth + portWidth + 20, 3, portBridgeWidth.intValue(), 19);
        this.lblPort2.setText(this.bundle_dialog_label.getString("dialog.add_rule.port_bridge"));
        this.toPort = new Text(container, 2048);
        this.toPort.setBounds(tmpWidth + portWidth + portBridgeWidth + 30, 0, portWidth.intValue(), 25);
        this.toPort.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.keyCode >= 48 && e.keyCode <= 57 && e.stateMask == 0 || e.keyCode >= 0x1000030 && e.keyCode <= 16777273 && e.stateMask == 0 || AddRuleDialog.checkKey(e.keyCode))) {
                    e.doit = false;
                }
            }
        });
        this.protocol = new Text(container, 2048);
        this.protocol.setVisible(false);
        this.lblSource = new Label(container, 0);
        this.lblSource.setBounds(0, 3, tmpWidth.intValue(), 19);
        this.lblSource.setAlignment(131072);
        this.lblSource.setText(this.bundle_dialog_label.getString("dialog.add_rule.source_title"));
        this.source = new Text(container, 2048);
        this.source.setBounds(tmpWidth + 10, 0, 596 - tmpWidth - 10, 25);
        this.source.setEnabled(true);
        this.lblSource2 = new Label(container, 256);
        this.lblSource2.setBounds(tmpWidth + 10, 3, 596 - tmpWidth - 10, 19);
        this.lblSource2.setText(this.bundle_dialog_label.getString("dialog.add_rule.source_example"));
        this.icmp2 = new Combo(container, 0);
        this.icmp2.setBounds(tmpWidth + 10, 0, 596 - tmpWidth - 10, 25);
        this.icmp2.setEnabled(false);
        this.icmp1 = new Combo(container, 0);
        this.icmp1.setBounds(tmpWidth + 10, 0, 596 - tmpWidth - 10, 25);
        this.icmp1.setEnabled(false);
        this.lblType = new Label(container, 0);
        this.lblType.setBounds(0, 3, tmpWidth.intValue(), 19);
        this.lblType.setText(this.bundle_dialog_label.getString("dialog.add_rule.type_title"));
        this.lblType.setAlignment(131072);
        this.lblCode = new Label(container, 0);
        this.lblCode.setBounds(0, 3, tmpWidth.intValue(), 19);
        this.lblCode.setText(this.bundle_dialog_label.getString("dialog.add_rule.code_title"));
        this.lblCode.setAlignment(131072);
        for (Map.Entry<String, String> entry : this.protocolList.getMap().entrySet()) {
            this.template.add(entry.getKey());
            this.template.setData(entry.getKey(), (Object)entry.getValue());
            Map<String, String> map = ParameterManager.getInstance(entry.getValue()).getMap();
            this.serviceMap.put(map.get("protocol") + "," + map.get("fromPort") + "," + map.get("toPort"), entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.bundle_icmp.getMap().entrySet()) {
            this.icmp1.add(entry.getKey());
            this.icmp1.setData(entry.getKey(), (Object)entry.getValue());
        }
        this.icmp1.setEnabled(false);
        this.icmp2.setEnabled(false);
        this.updateLayout();
        if (this.ip != null) {
            String title = this.serviceMap.get(this.ip.getIpProtocol() + "," + String.valueOf(this.ip.getFromPort()) + "," + String.valueOf(this.ip.getToPort()));
            if (title == null) {
                title = this.serviceMap.get(this.ip.getIpProtocol() + ",,");
            }
            this.template.select(this.template.indexOf(title));
            this.protocolSelected((String)this.template.getData(title));
            if (this.icmp1.isEnabled()) {
                this.icmp1.select(this.icmp1.indexOf(this.bundle_icmp.getReverseMap().get(String.valueOf(this.ip.getFromPort()))));
                this.icmpSelected(this.icmp1.getText());
            }
            if (this.icmp2.isEnabled()) {
                this.icmp2.select(this.icmp2.indexOf(ParameterManager.getInstance(this.icmp1.getText()).getReverseMap().get(String.valueOf(this.ip.getToPort()))));
            }
            this.protocol.setText(this.ip.getIpProtocol());
            if (this.ip.getFromPort() == this.ip.getToPort()) {
                this.fromPort.setText(String.valueOf(this.ip.getFromPort()));
            } else {
                this.fromPort.setText(String.valueOf(this.ip.getFromPort()));
                this.toPort.setText(String.valueOf(this.ip.getToPort()));
            }
            if (this.ip.getIpRange() == null || "".equals(this.ip.getIpRange())) {
                this.source.setText(this.ip.getSecurityGroupId());
            } else {
                this.source.setText(this.ip.getIpRange());
            }
        }
        this.template.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRuleDialog.this.protocolSelected(AddRuleDialog.this.protocolList.getValue(((Combo)e.getSource()).getText()));
            }
        });
        this.icmp1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRuleDialog.this.icmpSelected(((Combo)e.getSource()).getText());
            }
        });
        this.icmp2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRuleDialog.this.toPort.setText((String)((Combo)e.getSource()).getData(((Combo)e.getSource()).getText()));
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if ("".equals(this.protocol.getText()) || "".equals(this.fromPort.getText()) && "".equals(this.toPort.getText()) || "".equals(this.source.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        if (AddRuleDialog.isCidr(this.source.getText())) {
            this.returnIpRange = this.source.getText();
        } else if (AddRuleDialog.isSecurityGroupId(this.source.getText())) {
            this.returnSecurityGroupId = this.source.getText();
        } else if (AddRuleDialog.isUserIdGroupNamePair(this.source.getText())) {
            this.returnUserId = this.source.getText().substring(0, 12);
            this.returnGroupName = this.source.getText().substring(13).trim();
        } else {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_input_matched_string"));
            return;
        }
        if ("".equals(this.fromPort.getText())) {
            this.fromPort.setText(this.toPort.getText());
        } else if ("".equals(this.toPort.getText())) {
            this.toPort.setText(this.fromPort.getText());
        }
        this.returnProtocol = this.protocol.getText();
        this.returnFromPort = Integer.parseInt(this.fromPort.getText());
        this.returnToPort = Integer.parseInt(this.toPort.getText());
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.ip == null) {
            newShell.setText(this.bundle_dialog_name.getString("add_rule"));
        } else {
            newShell.setText(this.bundle_dialog_name.getString("edit_rule"));
        }
    }

    private static boolean isCidr(String str) {
        Pattern p = Pattern.compile("^([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])(\\.([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){3}/[0-9]{1,2}$");
        return p.matcher(str).find();
    }

    private static boolean isSecurityGroupId(String str) {
        Pattern p = Pattern.compile("^sg-[a-f0-9]{8}$");
        return p.matcher(str).find();
    }

    private static boolean isUserIdGroupNamePair(String str) {
        Pattern p = Pattern.compile("^[0-9]{12}/.+$");
        return p.matcher(str).find();
    }

    private static boolean checkKey(int keyCode) {
        int[] keys;
        for (int key : keys = new int[]{131072, 65536, 0x1000002, 0x1000003, 0x1000004, 0x1000001, 8, 262144, 262144, 127, 27, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015}) {
            if (keyCode != key) continue;
            return true;
        }
        return false;
    }

    public String getIpProtocol() {
        return this.returnProtocol;
    }

    public String getSecurityGroupId() {
        return this.returnSecurityGroupId;
    }

    public String getUserId() {
        return this.returnUserId;
    }

    public String getGroupName() {
        return this.returnGroupName;
    }

    public String getIpRange() {
        return this.returnIpRange;
    }

    public Integer getFromPort() {
        return this.returnFromPort;
    }

    public Integer getToPort() {
        return this.returnToPort;
    }

    private void protocolSelected(String selection) {
        Map<String, String> map = ParameterManager.getInstance(selection).getMap();
        this.protocol.setText(map.get("protocol"));
        this.protocol.setEnabled(false);
        if ("icmp".equals(map.get("protocol"))) {
            this.icmp1.setEnabled(true);
            this.fromPort.setEnabled(false);
            this.toPort.setEnabled(false);
            if (!"".equals(map.get("fromPort"))) {
                this.icmp1.select(this.icmp1.indexOf(this.bundle_icmp.getReverseMap().get(map.get("fromPort"))));
                this.icmp1.setEnabled(false);
                this.fromPort.setText(map.get("fromPort"));
                this.icmpSelected(this.icmp1.getText());
            }
        } else {
            this.icmp2.removeAll();
            this.icmp1.setEnabled(false);
            this.icmp2.setEnabled(false);
            if (!"".equals(map.get("fromPort"))) {
                this.fromPort.setText(map.get("fromPort"));
                this.fromPort.setEnabled(false);
            } else {
                this.fromPort.setEnabled(true);
            }
            if (!"".equals(map.get("toPort"))) {
                this.toPort.setText(map.get("toPort"));
                this.toPort.setEnabled(false);
            } else {
                this.toPort.setEnabled(true);
            }
        }
        this.updateLayout();
    }

    private void icmpSelected(String selection) {
        Map<String, String> map = ParameterManager.getInstance(selection).getMap();
        if (map.size() > 1) {
            this.icmp2.removeAll();
            for (Map.Entry<String, String> entry : ParameterManager.getInstance(selection).getMap().entrySet()) {
                this.icmp2.add(entry.getKey());
                this.icmp2.setData(entry.getKey(), (Object)entry.getValue());
            }
            this.icmp2.select(0);
            this.toPort.setText((String)this.icmp2.getData(this.icmp2.getText()));
            this.icmp2.setEnabled(true);
        } else {
            for (String value : map.values()) {
                this.toPort.setText(value);
            }
            this.icmp2.setEnabled(false);
        }
        this.updateLayout();
    }

    private void updateLayout() {
        int row = 0;
        if (this.template.isEnabled()) {
            this.enableControl((Control)this.lblService, row, 3);
            this.enableControl((Control)this.template, row, 0);
            ++row;
        } else {
            this.lblService.setVisible(false);
            this.lblService.setVisible(false);
        }
        if (this.fromPort.isEnabled() && this.toPort.isEnabled()) {
            this.enableControl((Control)this.lblPort, row, 3);
            this.enableControl((Control)this.lblPort2, row, 3);
            this.enableControl((Control)this.fromPort, row, 0);
            this.enableControl((Control)this.toPort, row, 0);
            ++row;
        } else {
            this.lblPort.setVisible(false);
            this.lblPort2.setVisible(false);
            this.fromPort.setVisible(false);
            this.toPort.setVisible(false);
        }
        if (this.icmp1.isEnabled()) {
            this.enableControl((Control)this.lblType, row, 3);
            this.enableControl((Control)this.icmp1, row, 0);
            ++row;
        } else {
            this.lblType.setVisible(false);
            this.icmp1.setVisible(false);
        }
        if (this.icmp2.isEnabled()) {
            this.enableControl((Control)this.lblCode, row, 3);
            this.enableControl((Control)this.icmp2, row, 0);
            ++row;
        } else {
            this.lblCode.setVisible(false);
            this.icmp2.setVisible(false);
        }
        if (this.source.isEnabled()) {
            this.enableControl((Control)this.lblSource, row, 3);
            this.enableControl((Control)this.lblSource2, row, 28);
            this.enableControl((Control)this.source, row, 0);
            ++row;
        } else {
            this.lblSource.setVisible(false);
            this.lblSource2.setVisible(false);
            this.source.setVisible(false);
        }
    }

    private void enableControl(Control c, int row, int offset) {
        int UNIT = 25;
        int y = row * 25 * 2 + offset;
        c.setBounds(c.getBounds().x, y, c.getBounds().width, c.getBounds().height);
        c.setVisible(true);
    }
}

