/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEndpointManager;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import com.clustercontrol.ws.jobmanagement.JobEndpoint;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TemplateJobUtil {
    private static IEndpointManager endpointManager = Activator.getEndpointManager();
    private static MessageManager bundle_param = MessageManager.getInstance("parameter");

    private TemplateJobUtil() {
    }

    public static JobTreeItem getTemplateJobRoot() throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        JobTreeItem jobTreeItem = endpoint.getJobTree(true);
        for (JobTreeItem item1 : jobTreeItem.getChildren()) {
            for (JobTreeItem item2 : item1.getChildren()) {
                if (!"AWS".equals(item2.getData().getId())) continue;
                return item2;
            }
        }
        return null;
    }

    public static void registerJob(TemplateJobnet jobnet) throws Exception {
        JobTreeItem parentItem = TemplateJobUtil.createDefaultJobnetItem();
        JobInfo parentInfo = parentItem.getData();
        parentInfo.setUpdate(true);
        parentInfo.setId(jobnet.getJobnetId());
        parentInfo.setJobunitId("AWS");
        parentInfo.setName(jobnet.getJobnetName());
        TemplateJobUtil.setNotifyGroupId(parentInfo.getNotifications(), parentInfo.getJobunitId(), parentInfo.getId());
        parentInfo.setPropertyFull(true);
        TemplateJobOSType osType = jobnet.getOsType();
        StringBuffer scripts = new StringBuffer();
        String scriptPrefix = null;
        if (osType.equals((Object)TemplateJobOSType.windows)) {
            scriptPrefix = "%HINEMOS_AGENT_HOME%\\var\\cloud\\";
        } else if (osType.equals((Object)TemplateJobOSType.unix)) {
            scriptPrefix = "${HINEMOS_AGENT_HOME}/var/cloud/";
        }
        for (TemplateJob tmpJob : jobnet.getJobs()) {
            if (!tmpJob.getCommandType().equals((Object)CommandType.script)) continue;
            scripts.append(" " + tmpJob.getCommand());
            tmpJob.setCommand(scriptPrefix + tmpJob.getCommand());
        }
        TemplateJob downloadJob = new TemplateJob();
        downloadJob.setJobId(jobnet.getJobnetId() + bundle_param.getString("template_job.constant.download_job_id_suffix"));
        downloadJob.setJobName(bundle_param.getString("template_job.constant.script_download_job_name"));
        downloadJob.setBehaviorInFailure(BehaviorInFailure.next);
        if (osType.equals((Object)TemplateJobOSType.windows)) {
            downloadJob.setCommand("java -cp %HINEMOS_AGENT_HOME%\\lib\\HinemosAgent.jar;%HINEMOS_AGENT_HOME%\\lib\\commons-logging-1.1.1.jar;%HINEMOS_AGENT_HOME%\\lib\\AgentWS.jar;%HINEMOS_AGENT_HOME%\\lib\\HinemosCommon.jar com.clustercontrol.agent.download.ScriptsDownload %HINEMOS_AGENT_HOME%\\conf\\Agent.properties" + scripts);
            downloadJob.setExecuteUser(bundle_param.getString("template_job.constant.windows_user"));
        } else if (osType.equals((Object)TemplateJobOSType.unix)) {
            downloadJob.setCommand("java -cp ${HINEMOS_AGENT_HOME}/lib/HinemosAgent.jar:${HINEMOS_AGENT_HOME}/lib/commons-logging-1.1.1.jar:${HINEMOS_AGENT_HOME}/lib/AgentWS.jar:${HINEMOS_AGENT_HOME}/lib/HinemosCommon.jar com.clustercontrol.agent.download.ScriptsDownload ${HINEMOS_AGENT_HOME}/conf/Agent.properties" + scripts);
            downloadJob.setExecuteUser(bundle_param.getString("template_job.constant.linux_user"));
        }
        downloadJob.setSuccessRangeStartValue(0);
        downloadJob.setSuccessRangeEndValue(0);
        JobTreeItem downloadItem = TemplateJobUtil.createJobTreeItem(downloadJob);
        TemplateJobUtil.addChildren(parentItem, downloadItem);
        String precedingJobId = downloadJob.getJobId();
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (TemplateJob tmpJob : jobnet.getJobs()) {
            if (precedingJobId != null) {
                tmpJob.setPrecedingJobId(precedingJobId);
            }
            JobTreeItem tmpItem = TemplateJobUtil.createJobTreeItem(tmpJob);
            TemplateJobUtil.addChildren(parentItem, tmpItem);
            precedingJobId = tmpJob.getJobId();
            if (tmpJob.getArgument() == null || tmpJob.getArgument().isEmpty()) continue;
            argMap.put(tmpJob.jobId, tmpJob.getArgument());
        }
        ArrayList<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
        for (Map.Entry entry : argMap.entrySet()) {
            JobParameterInfo param = new JobParameterInfo();
            param.setParamId("aws_" + (String)entry.getKey());
            param.setType(Integer.valueOf(1));
            param.setDescription(bundle_param.getString("template_job.constant.parameter.description", new Object[]{entry.getKey()}));
            param.setValue((String)entry.getValue());
            paramList.add(param);
        }
        TemplateJobUtil.InternalRegisterJob(parentItem, paramList);
    }

    private static void InternalRegisterJob(JobTreeItem item, List<JobParameterInfo> paramList) throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        JobTreeItem root = endpoint.getJobTree(true);
        JobTreeItem awsRoot = null;
        for (JobTreeItem item1 : root.getChildren()) {
            for (JobTreeItem item2 : item1.getChildren()) {
                if (!"AWS".equals(item2.getData().getId())) continue;
                awsRoot = item2;
                JobInfo info = TemplateJobUtil.getJobFull(awsRoot.getData());
                info.setEdit(true);
                awsRoot.setData(info);
            }
        }
        if (awsRoot == null) {
            awsRoot = TemplateJobUtil.createDefaultJobunitItem();
            JobInfo awsRootInfo = awsRoot.getData();
            awsRootInfo.setId("AWS");
            awsRootInfo.setJobunitId("AWS");
            awsRootInfo.setName(bundle_param.getString("template_job.constant.aws_job_unit_name"));
            TemplateJobUtil.setNotifyGroupId(awsRootInfo.getNotifications(), awsRootInfo.getJobunitId(), awsRootInfo.getId());
            TemplateJobUtil.addChildren((JobTreeItem)root.getChildren().get(0), awsRoot);
        }
        awsRoot.getData().getParam().addAll(paramList);
        TemplateJobUtil.addChildren(awsRoot, item);
        TemplateJobUtil.removeTreeParent(root);
        endpoint.registerJob(root);
    }

    public static JobInfo getJobFull(JobInfo jobInfo) throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        return endpoint.getJobFull(jobInfo);
    }

    public static void addChildren(JobTreeItem parent, JobTreeItem child) {
        parent.getChildren().add(child);
        child.setParent(parent);
    }

    private static void removeTreeParent(JobTreeItem item) {
        List children = item.getChildren();
        for (JobTreeItem child : children) {
            child.setParent(null);
            TemplateJobUtil.removeTreeParent(child);
        }
    }

    public static JobTreeItem createDefaultJobunitItem() {
        JobTreeItem item = new JobTreeItem();
        JobInfo info = new JobInfo();
        info.setWaitRule(TemplateJobUtil.getDefaultWaitRuleInfo());
        info.setType(Integer.valueOf(0));
        List notifications = info.getNotifications();
        notifications.clear();
        notifications.addAll(TemplateJobUtil.getDefaultNotifications());
        List endStatusInfos = info.getEndStatus();
        endStatusInfos.clear();
        endStatusInfos.addAll(TemplateJobUtil.getJobEndStatusInfos());
        List params = info.getParam();
        for (ArrayList param : SystemParameterConstant.ALL) {
            JobParameterInfo paramInfo = new JobParameterInfo();
            paramInfo.setParamId((String)param.get(0));
            paramInfo.setType(Integer.valueOf(0));
            paramInfo.setValue("(" + Messages.getString((String)"auto") + ")");
            paramInfo.setDescription((String)param.get(1));
            params.add(paramInfo);
        }
        item.setData(info);
        return item;
    }

    public static JobTreeItem createDefaultJobnetItem() {
        JobTreeItem item = new JobTreeItem();
        JobInfo info = new JobInfo();
        info.setWaitRule(TemplateJobUtil.getDefaultWaitRuleInfo());
        info.setType(Integer.valueOf(1));
        List notifications = info.getNotifications();
        notifications.clear();
        notifications.addAll(TemplateJobUtil.getDefaultNotifications());
        List endStatusInfos = info.getEndStatus();
        endStatusInfos.clear();
        endStatusInfos.addAll(TemplateJobUtil.getJobEndStatusInfos());
        item.setData(info);
        return item;
    }

    public static JobTreeItem createDefaultJobItem() {
        JobTreeItem item = new JobTreeItem();
        JobInfo info = new JobInfo();
        info.setWaitRule(TemplateJobUtil.getDefaultWaitRuleInfo());
        info.setType(Integer.valueOf(2));
        info.setCommand(TemplateJobUtil.getDefaultCommandInfo());
        List notifications = info.getNotifications();
        notifications.clear();
        notifications.addAll(TemplateJobUtil.getDefaultNotifications());
        List endStatusInfos = info.getEndStatus();
        endStatusInfos.clear();
        endStatusInfos.addAll(TemplateJobUtil.getJobEndStatusInfos());
        item.setData(info);
        return item;
    }

    private static JobWaitRuleInfo getDefaultWaitRuleInfo() {
        JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
        jobWaitRuleInfo.setSuspend(Integer.valueOf(0));
        jobWaitRuleInfo.setSkip(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendarEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setStartDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayJob(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayJobValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperationEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndStatus(Integer.valueOf(0));
        jobWaitRuleInfo.setEndStatus(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperationType(Integer.valueOf(0));
        return jobWaitRuleInfo;
    }

    private static JobCommandInfo getDefaultCommandInfo() {
        JobCommandInfo jobCommandInfo = new JobCommandInfo();
        jobCommandInfo.setFacilityID(SystemParameterConstant.getParamText((String)"FACILITY_ID"));
        jobCommandInfo.setScope("");
        jobCommandInfo.setProcessingMethod(Integer.valueOf(0));
        jobCommandInfo.setStartCommand("");
        jobCommandInfo.setStopCommand("");
        jobCommandInfo.setUser("");
        jobCommandInfo.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)true)));
        jobCommandInfo.setErrorEndValue(Integer.valueOf(-1));
        return jobCommandInfo;
    }

    private static List<JobNotificationsInfo> getDefaultNotifications() {
        ArrayList<JobNotificationsInfo> notifications = new ArrayList<JobNotificationsInfo>();
        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;
        infoStart = new JobNotificationsInfo();
        infoStart.setType(Integer.valueOf(3));
        infoStart.setPriority(Integer.valueOf(3));
        notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setPriority(Integer.valueOf(3));
        notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setPriority(Integer.valueOf(2));
        notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setPriority(Integer.valueOf(0));
        notifications.add(infoAbnormal);
        return notifications;
    }

    private static List<JobEndStatusInfo> getJobEndStatusInfos() {
        ArrayList<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo infoNormal = new JobEndStatusInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setValue(Integer.valueOf(0));
        infoNormal.setStartRangeValue(Integer.valueOf(0));
        infoNormal.setEndRangeValue(Integer.valueOf(0));
        jobEndStatusInfos.add(infoNormal);
        JobEndStatusInfo infoWarning = new JobEndStatusInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setValue(Integer.valueOf(1));
        infoWarning.setStartRangeValue(Integer.valueOf(1));
        infoWarning.setEndRangeValue(Integer.valueOf(1));
        jobEndStatusInfos.add(infoWarning);
        JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setValue(Integer.valueOf(-1));
        jobEndStatusInfos.add(infoAbnormal);
        return jobEndStatusInfos;
    }

    public static void setNotifyGroupId(List<JobNotificationsInfo> notifications, String jobunitId, String jobId) {
        for (JobNotificationsInfo info : notifications) {
            info.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupIdJob((String)jobunitId, (String)jobId, (Integer)0));
        }
    }

    public static JobTreeItem createJobTreeItem(TemplateJob templateJob) {
        JobTreeItem item = TemplateJobUtil.createDefaultJobItem();
        JobInfo jobInfo = item.getData();
        jobInfo.setJobunitId("AWS");
        jobInfo.setId(templateJob.getJobId());
        jobInfo.setName(templateJob.getJobName());
        item.getData().setUpdate(true);
        JobWaitRuleInfo jobWaitRuleInfo = jobInfo.getWaitRule();
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(YesNoConstant.booleanToType((boolean)templateJob.getBehaviorInFailure().isEndJudgementEnabled())));
        jobWaitRuleInfo.setEndValue(templateJob.getBehaviorInFailure().getEndValueInFailure());
        JobCommandInfo jobCommandInfo = jobInfo.getCommand();
        jobCommandInfo.setStartCommand(templateJob.getCommand());
        jobCommandInfo.setStopCommand(bundle_param.getString("template_job.constant.stop_command"));
        jobCommandInfo.setUser(templateJob.getExecuteUser());
        jobCommandInfo.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)true)));
        jobCommandInfo.setErrorEndValue(Integer.valueOf(-1));
        item.getData().setCommand(jobCommandInfo);
        ArrayList<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo infoNormal = new JobEndStatusInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setValue(Integer.valueOf(0));
        infoNormal.setStartRangeValue(templateJob.getSuccessRangeStartValue());
        infoNormal.setEndRangeValue(templateJob.getSuccessRangeEndValue());
        jobEndStatusInfos.add(infoNormal);
        JobEndStatusInfo infoWarning = new JobEndStatusInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setValue(Integer.valueOf(1));
        infoWarning.setStartRangeValue(templateJob.getSuccessRangeStartValue());
        infoWarning.setEndRangeValue(templateJob.getSuccessRangeEndValue());
        jobEndStatusInfos.add(infoWarning);
        JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setValue(Integer.valueOf(-1));
        jobEndStatusInfos.add(infoAbnormal);
        item.getData().getEndStatus().clear();
        item.getData().getEndStatus().addAll(jobEndStatusInfos);
        if (templateJob.getPrecedingJobId() != null && !templateJob.getPrecedingJobId().equals("")) {
            ArrayList<JobObjectInfo> jobObjectInfos = new ArrayList<JobObjectInfo>();
            for (Integer endValueForJudgement : templateJob.behaviorInFailure.getEndValueForJudgement()) {
                JobObjectInfo info = new JobObjectInfo();
                info.setJobId(templateJob.getPrecedingJobId());
                info.setType(Integer.valueOf(1));
                info.setValue(endValueForJudgement);
                jobObjectInfos.add(info);
            }
            item.getData().getWaitRule().getObject().clear();
            item.getData().getWaitRule().getObject().addAll(jobObjectInfos);
            if (templateJob.behaviorInFailure.getEndValueForJudgement().length > 1) {
                item.getData().getWaitRule().setCondition(Integer.valueOf(1));
            }
        }
        if (templateJob.getArgument() != null && !templateJob.getArgument().equals("")) {
            item.getData().getCommand().setStartCommand(item.getData().getCommand().getStartCommand() + " #[" + "aws_" + templateJob.getJobId() + "]");
        }
        TemplateJobUtil.setNotifyGroupId(item.getData().getNotifications(), "AWS", templateJob.getJobId());
        item.getData().setPropertyFull(true);
        return item;
    }

    public static List<TemplateJobnet> getTemplateJobList(Boolean listOnly) throws Exception {
        LinkedList<TemplateJobnet> templateJobs = new LinkedList<TemplateJobnet>();
        JobTreeItem awsRoot = TemplateJobUtil.getTemplateJobRoot();
        if (awsRoot != null) {
            HashMap<String, JobTreeItem> itemMap = new HashMap<String, JobTreeItem>();
            for (JobTreeItem jobnetItem : awsRoot.getChildren()) {
                TemplateJobnet templateJob = new TemplateJobnet();
                templateJob.setJobnetId(jobnetItem.getData().getId());
                templateJob.setJobnetName(jobnetItem.getData().getName());
                itemMap.put(templateJob.getJobnetId(), jobnetItem);
                templateJobs.add(templateJob);
            }
            if (!listOnly.booleanValue()) {
                awsRoot.setData(TemplateJobUtil.getJobFull(awsRoot.getData()));
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (JobParameterInfo paramInfo : awsRoot.getData().getParam()) {
                    paramMap.put(paramInfo.getParamId(), paramInfo.getValue());
                }
                for (TemplateJobnet jobnet : templateJobs) {
                    JobTreeItem item = (JobTreeItem)itemMap.get(jobnet.getJobnetId());
                    LinkedList<TemplateJob> jobs = new LinkedList<TemplateJob>();
                    for (JobTreeItem jobItem : item.getChildren()) {
                        JobInfo jobInfo = TemplateJobUtil.getJobFull(jobItem.getData());
                        TemplateJob job = new TemplateJob();
                        job.setJobId(jobInfo.getId());
                        job.setJobName(jobInfo.getName());
                        job.setCommand(jobInfo.getCommand().getStartCommand());
                        job.setExecuteUser(jobInfo.getCommand().getUser());
                        if (paramMap.containsKey("aws_" + job.getJobId())) {
                            job.setArgument((String)paramMap.get("aws_" + job.getJobId()));
                        }
                        jobs.add(job);
                    }
                    jobnet.setJobs(jobs);
                }
            }
        }
        return templateJobs;
    }

    public static List<String> getTemplateScripts() throws Exception {
        ArrayList<String> scripts = new ArrayList<String>();
        CloudEndpoint endpoint = endpointManager.getEndpoint(CloudEndpoint.class);
        scripts.addAll(endpoint.getTemplateScripts());
        return scripts;
    }

    public static enum BehaviorInFailure {
        next(new Integer[]{0, -1}, true, -1),
        stop(new Integer[]{0}, true, 0),
        end(new Integer[]{0}, false, null);

        private MessageManager param = MessageManager.getInstance("parameter");
        private final Parameter parameter;

        private BehaviorInFailure(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
            this.parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
        }

        public String toString() {
            switch (this) {
                case next: {
                    return this.param.getString("template_job.behavior_in_failure.next");
                }
                case stop: {
                    return this.param.getString("template_job.behavior_in_failure.stop");
                }
                case end: {
                    return this.param.getString("template_job.behavior_in_failure.end");
                }
            }
            throw new IllegalStateException();
        }

        public BehaviorInFailure valueOf(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
            Parameter parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
            if (BehaviorInFailure.next.param.hashCode() == parameter.hashCode()) {
                return next;
            }
            if (BehaviorInFailure.stop.param.hashCode() == parameter.hashCode()) {
                return stop;
            }
            if (BehaviorInFailure.end.param.hashCode() == parameter.hashCode()) {
                return end;
            }
            throw new IllegalStateException();
        }

        Integer[] getEndValueForJudgement() {
            return this.parameter.getEndValueForJudgement();
        }

        Boolean isEndJudgementEnabled() {
            return this.parameter.getEndJudgementEnabled();
        }

        Integer getEndValueInFailure() {
            return this.parameter.getEndValueInFailure();
        }

        private static class Parameter {
            private final Integer[] endValueForJudgement;
            private final Boolean endJudgementEnabled;
            private final Integer endValueInFailure;

            public Parameter(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
                this.endValueForJudgement = endValueForJudgement;
                this.endJudgementEnabled = endJudgementEnabled;
                this.endValueInFailure = endValueInFailure;
            }

            public Integer[] getEndValueForJudgement() {
                return this.endValueForJudgement;
            }

            public Boolean getEndJudgementEnabled() {
                return this.endJudgementEnabled;
            }

            public Integer getEndValueInFailure() {
                return this.endValueInFailure;
            }
        }
    }

    public static enum CommandType {
        command,
        script;

    }

    public static enum TemplateJobOSType {
        unix,
        windows;

    }

    public static class TemplateJob {
        private Integer orderNo;
        private String precedingJobId;
        private String jobId;
        private String jobName;
        private CommandType commandType;
        private String command;
        private String argument;
        private String executeUser;
        private BehaviorInFailure behaviorInFailure;
        private Integer successRangeStartValue;
        private Integer successRangeEndValue;

        public void setOrderNo(Integer orderNo) {
            this.orderNo = orderNo;
        }

        public Integer getOrderNo() {
            return this.orderNo;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public CommandType getCommandType() {
            return this.commandType;
        }

        public void setCommandType(CommandType commandType) {
            this.commandType = commandType;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getArgument() {
            return this.argument;
        }

        public void setArgument(String argument) {
            this.argument = argument;
        }

        public String getExecuteUser() {
            return this.executeUser;
        }

        public void setExecuteUser(String executeUser) {
            this.executeUser = executeUser;
        }

        public BehaviorInFailure getBehaviorInFailure() {
            return this.behaviorInFailure;
        }

        public void setBehaviorInFailure(BehaviorInFailure behaviorInFailure) {
            this.behaviorInFailure = behaviorInFailure;
        }

        public Integer getSuccessRangeStartValue() {
            return this.successRangeStartValue;
        }

        public void setSuccessRangeStartValue(Integer successRangeStartValue) {
            this.successRangeStartValue = successRangeStartValue;
        }

        public Integer getSuccessRangeEndValue() {
            return this.successRangeEndValue;
        }

        public void setSuccessRangeEndValue(Integer successRangeEndValue) {
            this.successRangeEndValue = successRangeEndValue;
        }

        public void setPrecedingJobId(String precedingJobId) {
            this.precedingJobId = precedingJobId;
        }

        public String getPrecedingJobId() {
            return this.precedingJobId;
        }
    }

    public static class TemplateJobnet {
        private String jobnetId;
        private String jobnetName;
        private TemplateJobOSType osType;
        private List<TemplateJob> jobs;

        public String getJobnetId() {
            return this.jobnetId;
        }

        public void setJobnetId(String jobnetId) {
            this.jobnetId = jobnetId;
        }

        public String getJobnetName() {
            return this.jobnetName;
        }

        public void setJobnetName(String jobnetName) {
            this.jobnetName = jobnetName;
        }

        public TemplateJobOSType getOsType() {
            return this.osType;
        }

        public void setOsType(TemplateJobOSType osType) {
            this.osType = osType;
        }

        public List<TemplateJob> getJobs() {
            return this.jobs;
        }

        public void setJobs(List<TemplateJob> jobs) {
            this.jobs = jobs;
        }
    }
}

