/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private static final Map<String, MessageManager> managers = new HashMap<String, MessageManager>();
    private String fileName;
    private ResourceBundle bundle;

    private MessageManager(String fileName) {
        this.fileName = fileName;
        this.bundle = ResourceBundle.getBundle(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageManager getInstance(String fileName) {
        MessageManager manager = null;
        Map<String, MessageManager> map = managers;
        synchronized (map) {
            if (managers.containsKey(fileName)) {
                manager = managers.get(fileName);
            } else {
                manager = new MessageManager(fileName);
                managers.put(fileName, manager);
            }
        }
        return manager;
    }

    public String getString(String key, Object[] args) {
        MessageFormat messageFormat = new MessageFormat(this.getString(key));
        return messageFormat.format(args);
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getString(String key, String def) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }

    public String getString(String key, Object[] args, Locale locale) {
        MessageFormat messageFormat = new MessageFormat(this.getString(key, locale));
        return messageFormat.format(args);
    }

    public String getString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.fileName, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getString(String key, String def, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.fileName, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }
}

