/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlUtil {
    private ControlUtil() {
    }

    public static <T> T deepCopy(T value) {
        Object model = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(value);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            model = in.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (T)model;
    }

    public static void setRequired(Control[] requiredControls) {
        for (Control requiredControl : requiredControls) {
            if (!(requiredControl instanceof Text)) continue;
            if (((Text)requiredControl).getText().equals("")) {
                requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            }
            ((Text)requiredControl).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (((Text)e.getSource()).getText().equals("")) {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    } else {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    }
                }
            });
        }
    }

    public static void setInputRestriction(Text[] texts, final Pattern pattern) {
        for (Text text : texts) {
            text.addVerifyListener(new VerifyListener(){
                Matcher matcher;

                public void verifyText(VerifyEvent e) {
                    if (!e.text.isEmpty()) {
                        String srcText = ((Text)e.getSource()).getText();
                        this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                        if (!this.matcher.matches()) {
                            e.doit = false;
                        }
                    }
                }
            });
        }
    }

    public static void setInputRestriction(Control[] controls, final Pattern pattern) {
        for (Control control : controls) {
            if (control instanceof Text) {
                ((Text)control).addVerifyListener(new VerifyListener(){
                    Matcher matcher;

                    public void verifyText(VerifyEvent e) {
                        if (!e.text.isEmpty()) {
                            String srcText = ((Text)e.getSource()).getText();
                            this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                            if (!this.matcher.matches()) {
                                e.doit = false;
                            }
                        }
                    }
                });
                continue;
            }
            if (!(control instanceof Combo)) continue;
            ((Combo)control).addVerifyListener(new VerifyListener(){
                Matcher matcher;

                public void verifyText(VerifyEvent e) {
                    if (!e.text.isEmpty()) {
                        String srcText = ((Combo)e.getSource()).getText();
                        this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                        if (!this.matcher.matches()) {
                            e.doit = false;
                        }
                    }
                }
            });
        }
    }

    public static void setDigitOnlyInput(Text[] texts) {
        for (Text text : texts) {
            text.addModifyListener(new ModifyListener(){
                Pattern pattern = Pattern.compile("^-?[0-9]+$");
                Matcher matcher;

                public void modifyText(ModifyEvent e) {
                    this.matcher = this.pattern.matcher(((Text)e.getSource()).getText());
                    if (this.matcher.find()) {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    }
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (!Character.isDigit(e.character) && !Character.isISOControl(e.character) && e.character != '-') {
                        e.doit = false;
                    }
                }
            });
        }
    }
}

