/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.resources;

import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.aws.resources.Snapshot;
import com.clustercontrol.cloud.aws.resources.Subnet;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.KeyPair;
import com.clustercontrol.ws.cloud.Region;
import com.clustercontrol.ws.cloud.SecurityGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CloudResourceProviderImpl
implements CloudResourceProvider {
    private CloudEndpoint endpoint;

    public CloudResourceProviderImpl(CloudEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public List<String> getAllRegion() {
        try {
            ArrayList<String> regions = new ArrayList<String>();
            for (Region r : this.endpoint.getAllRegion()) {
                regions.add(r.getRegionName());
            }
            return regions;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<AvailabilityZone> getAvailabilityZones(String region) {
        try {
            ArrayList<AvailabilityZone> azs = new ArrayList<AvailabilityZone>();
            for (com.clustercontrol.ws.cloud.AvailabilityZone wsAZ : this.endpoint.getAvailabilityZones(region)) {
                AvailabilityZone az = new AvailabilityZone();
                az.setZoneName(wsAZ.getZoneName());
                azs.add(az);
            }
            return azs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Image> getImages(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Image> images = new ArrayList<Image>();
            for (com.clustercontrol.ws.cloud.Image wsImage : this.endpoint.getImages(region, wsFilters)) {
                Image image = new Image();
                image.setImageId(wsImage.getImageId());
                image.setName(wsImage.getName());
                images.add(image);
            }
            return images;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<GroupIdentifier> getSecurityGroupsByRegion(String regionName) {
        List<Filter> filters = Collections.emptyList();
        return this.getSecurityGroups(regionName, filters);
    }

    @Override
    public List<GroupIdentifier> getSecurityGroups(String regionName, List<Filter> filters) {
        try {
            List wsSGs = Collections.emptyList();
            if (!filters.isEmpty()) {
                ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
                for (Filter filter : filters) {
                    com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                    wsFilter.setName(filter.getName());
                    wsFilter.getValues().addAll(filter.getValues());
                    wsFilters.add(wsFilter);
                }
                wsSGs = this.endpoint.getSecurityGroups(regionName, wsFilters);
            } else {
                wsSGs = this.endpoint.getSecurityGroupsByRegion(regionName);
            }
            ArrayList<GroupIdentifier> sgs = new ArrayList<GroupIdentifier>();
            for (SecurityGroup wsSG : wsSGs) {
                GroupIdentifier gi = new GroupIdentifier();
                gi.setGroupId(wsSG.getGroupId());
                gi.setGroupName(wsSG.getGroupName());
                gi.setVpcId(wsSG.getVpcId());
                sgs.add(gi);
            }
            return sgs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllInstanceType() {
        try {
            return this.endpoint.getAllInstanceType();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getKeyNames(String region) {
        try {
            ArrayList<String> ketNames = new ArrayList<String>();
            for (KeyPair k : this.endpoint.getKeyNames(region)) {
                ketNames.add(k.getKeyName());
            }
            return ketNames;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Snapshot> getSnapshots(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            for (com.clustercontrol.ws.cloud.Snapshot ws : this.endpoint.getSnapshots(region, wsFilters)) {
                Snapshot s = new Snapshot();
                s.setSnapshotId(ws.getSnapshotId());
                s.setDescription(ws.getDescription());
                s.setRegion(ws.getRegion());
                snapshots.add(s);
            }
            return snapshots;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllVolumeType() {
        try {
            ArrayList<String> volumeTypes = new ArrayList<String>();
            for (String v : this.endpoint.getAllVolumeType()) {
                volumeTypes.add(v);
            }
            return volumeTypes;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllServiceName() {
        try {
            return this.endpoint.getAllServiceName();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Subnet> getSubnets(String regionName, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            for (com.clustercontrol.ws.cloud.Subnet wsSubnet : this.endpoint.getSubnets(regionName, wsFilters)) {
                Subnet subnet = new Subnet();
                subnet.setSubnetId(wsSubnet.getSubnetId());
                subnet.setVpcId(wsSubnet.getVpcId());
                subnet.setAvailabilityZone(wsSubnet.getAvailabilityZone());
                subnet.setCidrBlock(wsSubnet.getCidrBlock());
                subnets.add(subnet);
            }
            return subnets;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Subnet> getSubnetsByRegion(String regionName) {
        try {
            List emptyList = Collections.emptyList();
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            for (com.clustercontrol.ws.cloud.Subnet wsSubnet : this.endpoint.getSubnets(regionName, emptyList)) {
                Subnet subnet = new Subnet();
                subnet.setSubnetId(wsSubnet.getSubnetId());
                subnet.setVpcId(wsSubnet.getVpcId());
                subnet.setAvailabilityZone(wsSubnet.getAvailabilityZone());
                subnet.setCidrBlock(wsSubnet.getCidrBlock());
                subnets.add(subnet);
            }
            return subnets;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

