/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateTemplateRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.Inventory;
import com.clustercontrol.cloud.aws.presenter.Template;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudTemplate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TemplateManagement
extends Element
implements ITemplateManagement {
    private Inventory inventory;
    private static List<Template> templates;

    public TemplateManagement(Inventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.inventory.getCloudResourceManager();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public ITemplate[] getTemplates() {
        if (templates == null) {
            templates = new ArrayList<Template>();
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            try {
                List cloudTemplates = endpoint.getAllTemplates();
                for (CloudTemplate cloudTemplate : cloudTemplates) {
                    Template template = new Template(this, cloudTemplate);
                    templates.add(template);
                }
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        return templates.toArray(new Template[0]);
    }

    @Override
    public void update() {
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            List cloudTemplates = endpoint.getAllTemplates();
            this.internalUpdate(cloudTemplates);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public void internalUpdate(List<CloudTemplate> cloudTemplates) throws CloudModelException {
        Template template;
        ArrayList<Template> tmpTemplates = new ArrayList<Template>(templates);
        ArrayList<CloudTemplate> tmpCloudTemplates = new ArrayList<CloudTemplate>(cloudTemplates);
        Iterator itrCloudTemplates = tmpCloudTemplates.iterator();
        block0: while (itrCloudTemplates.hasNext()) {
            CloudTemplate cloudTemplate = (CloudTemplate)itrCloudTemplates.next();
            Iterator itrTemplates = tmpTemplates.iterator();
            while (itrTemplates.hasNext()) {
                template = (Template)itrTemplates.next();
                if (!cloudTemplate.getTemplateId().equals(template.getTemplateId())) continue;
                template.internalUpdate(cloudTemplate);
                itrTemplates.remove();
                itrCloudTemplates.remove();
                continue block0;
            }
        }
        for (Template template2 : tmpTemplates) {
            templates.remove(template2);
            this.fireElementRemoved(ITemplateManagement.p2.templates, template2);
        }
        for (CloudTemplate cloudTemplate : tmpCloudTemplates) {
            template = new Template(this, cloudTemplate);
            templates.add(template);
            this.fireElementAdded(ITemplateManagement.p2.templates, template);
        }
    }

    @Override
    public Template createTemplate(CreateTemplateRequest request) {
        Template template = null;
        try {
            CloudTemplate cloudTemplate = new CloudTemplate();
            cloudTemplate.setTemplateId(request.getTemplateId());
            cloudTemplate.setTemplateName(request.getTemplateName());
            cloudTemplate.setImageId(request.getImageId());
            cloudTemplate.setRegion(request.getRegion());
            cloudTemplate.setLaunchJobId(request.getLaunchJobId());
            cloudTemplate.setStartJobId(request.getStartJobId());
            cloudTemplate.setStopJobId(request.getStopJobId());
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudTemplate addedTemplate = endpoint.addTemplate(cloudTemplate);
            template = new Template(this, addedTemplate);
            templates.add(template);
            this.fireElementAdded(ITemplateManagement.p2.templates, template);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return template;
    }

    @Override
    public Template modifyTemplate(ITemplate argTemplate, CreateTemplateRequest request) {
        Template template = (Template)argTemplate;
        try {
            CloudTemplate cloudTemplate = template.getTemplate();
            cloudTemplate.setTemplateName(request.getTemplateName());
            cloudTemplate.setImageId(request.getImageId());
            cloudTemplate.setRegion(request.getRegion());
            cloudTemplate.setLaunchJobId(request.getLaunchJobId());
            cloudTemplate.setStartJobId(request.getStartJobId());
            cloudTemplate.setStopJobId(request.getStopJobId());
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            endpoint.modifyTemplate(cloudTemplate);
            CloudTemplate modifiedTemplate = endpoint.getTemplate(template.getTemplateId());
            template.internalUpdate(modifiedTemplate);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return template;
    }

    @Override
    public void deleteTemplate(String templateId) {
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            endpoint.removeTemplate(templateId);
            for (Template template : templates) {
                if (!templateId.equals(template.getTemplateId())) continue;
                templates.remove(template);
                this.fireElementRemoved(ITemplateManagement.p2.templates, template);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public ITemplate getTemplate(String templateId) {
        for (Template template : templates) {
            if (!template.getTemplateId().equals(templateId)) continue;
            return template;
        }
        CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        try {
            CloudTemplate cloudTemplate = endpoint.getTemplate(templateId);
            if (cloudTemplate != null) {
                Template template = new Template(this, cloudTemplate);
                templates.add(template);
                this.fireElementAdded(ITemplateManagement.p2.templates, template);
                return template;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return null;
    }
}

