/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BackupManagement;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.presenter.IStorageBackupRoot;
import com.clustercontrol.cloud.aws.presenter.StorageBackup;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudStorageBackup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StorageBackupRoot
extends Element
implements IStorageBackupRoot {
    private BackupManagement backupManagement;
    private List<StorageBackup> storageBackups;

    public StorageBackupRoot(BackupManagement backupManagement) {
        this.backupManagement = backupManagement;
    }

    @Override
    public void update() throws CloudModelException {
        List cloudStorageBackup = Collections.emptyList();
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            cloudStorageBackup = endpoint.getStorageBackupsByRegion(this.getBackupManagement().getRegion().getRegionName());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        this.internalUpdate(cloudStorageBackup);
        super.update();
    }

    public boolean isInitialized() {
        return this.storageBackups != null;
    }

    private List<StorageBackup> getStorageBackupsList() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.storageBackups;
    }

    public void internalUpdate(List<CloudStorageBackup> cloudInstancesBackups) throws CloudModelException {
        if (this.isInitialized()) {
            ArrayList<StorageBackup> instancesBackupsTemp = new ArrayList<StorageBackup>(this.storageBackups);
            ArrayList<CloudStorageBackup> cloudStorageBackupsTemp = new ArrayList<CloudStorageBackup>(cloudInstancesBackups);
            Iterator cloudStorageBackupsIter = cloudStorageBackupsTemp.iterator();
            block0: while (cloudStorageBackupsIter.hasNext()) {
                CloudStorageBackup csb = (CloudStorageBackup)cloudStorageBackupsIter.next();
                Iterator StorageBackupsIter = instancesBackupsTemp.iterator();
                while (StorageBackupsIter.hasNext()) {
                    StorageBackup s = (StorageBackup)StorageBackupsIter.next();
                    if (!csb.getSnapshotId().equals(s.getSnapshotId()) || !this.getBackupManagement().getRegion().getRegionName().equals(csb.getRegion())) continue;
                    s.internalUpdate(csb);
                    StorageBackupsIter.remove();
                    cloudStorageBackupsIter.remove();
                    continue block0;
                }
            }
            for (StorageBackup i : instancesBackupsTemp) {
                this.getStorageBackupsList().remove(i);
                this.fireElementRemoved(IStorageBackupRoot.p2.storageBackups, i);
            }
            for (CloudStorageBackup cib : cloudStorageBackupsTemp) {
                StorageBackup newStorageBackup = StorageBackup.createStorageBackup(this, cib);
                this.getStorageBackupsList().add(newStorageBackup);
                this.fireElementAdded(IStorageBackupRoot.p2.storageBackups, newStorageBackup);
            }
        } else {
            ArrayList<StorageBackup> tempStorageBackups = new ArrayList<StorageBackup>();
            for (CloudStorageBackup storageBackup : cloudInstancesBackups) {
                tempStorageBackups.add(StorageBackup.createStorageBackup(this, storageBackup));
            }
            this.storageBackups = tempStorageBackups;
        }
    }

    @Override
    public BackupManagement getBackupManagement() {
        return this.backupManagement;
    }

    public StorageBackup[] getStorageBackups() {
        return this.getStorageBackupsList().toArray(new StorageBackup[0]);
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.backupManagement.getCloudResourceManager();
    }

    public IStorageBackup getStorageBackup(String snapshotId) {
        for (StorageBackup backup : this.getStorageBackupsList()) {
            if (!backup.getSnapshotId().equals(snapshotId)) continue;
            return backup;
        }
        return null;
    }

    @Override
    public IStorageBackup createStorageBackup(CreateStorageBackupRequest request) {
        com.clustercontrol.ws.cloud.CreateStorageBackupRequest wsRequest = new com.clustercontrol.ws.cloud.CreateStorageBackupRequest();
        wsRequest.setSnapshotName(request.getSnapshotName());
        wsRequest.setRegionName(request.getRegion());
        wsRequest.setStorageId(request.getStorageId());
        wsRequest.setSnapshotName(request.getSnapshotName());
        wsRequest.setDescription(request.getDescription());
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudStorageBackup backup = endpoint.addStorageBackup(wsRequest);
            StorageBackup newBackup = StorageBackup.createStorageBackup(this, backup);
            this.getStorageBackupsList().add(newBackup);
            this.fireElementAdded(IStorageBackupRoot.p2.storageBackups, newBackup);
            return newBackup;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void deleteStorageBackup(String snapshotId) {
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            endpoint.removeStorageBackup(this.backupManagement.getRegion().getRegionName(), snapshotId);
            IStorageBackup removeBackup = this.getStorageBackup(snapshotId);
            this.getStorageBackupsList().remove(removeBackup);
            this.fireElementRemoved(IStorageBackupRoot.p2.storageBackups, removeBackup);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }
}

