/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.PropEvent;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.PropertyObserver2;
import com.clustercontrol.cloud.aws.presenter.ValueObserver2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropChangedEventNotifier {
    public static final PropertyId2<AllPropertyObserver> allProperty = new PropertyId2();
    private Map<Object, List<?>> listenersMap = new HashMap();
    private List<Command> commands = new ArrayList<Command>();
    protected int notifyingDepth = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, O extends PropertyObserver2<P>> void addPropertyObserver(final PropertyId2<O> pid, final O observer) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            if (this.notifyingDepth == 0) {
                this.doAdd(pid, observer);
            } else {
                this.commands.add(new Command(){

                    @Override
                    public void execute() {
                        PropChangedEventNotifier.this.doAdd(pid, observer);
                    }
                });
            }
        }
    }

    private void doAdd(Object pid, Object observer) {
        List<?> list = this.listenersMap.get(pid);
        if (list == null) {
            list = new ArrayList();
            this.listenersMap.put(pid, list);
        }
        list.add(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, O extends PropertyObserver2<P>> void removePropertyObserver(final PropertyId2<O> pid, final O observer) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            if (this.notifyingDepth == 0) {
                this.doRemove(pid, observer);
            } else {
                this.commands.add(new Command(){

                    @Override
                    public void execute() {
                        PropChangedEventNotifier.this.doRemove(pid, observer);
                    }
                });
            }
        }
    }

    private void doRemove(Object pid, Object observer) {
        List<?> list = this.listenersMap.get(pid);
        if (list != null) {
            list.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P, O extends PropertyObserver2<P>> void fireEvent(PropEvent<P, O> event) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            ++this.notifyingDepth;
            List<?> list = this.listenersMap.get(event.getPropertyId());
            if (list != null) {
                for (PropertyObserver2 observer : list) {
                    event.dispatch(observer);
                }
            }
            for (Command c : this.commands) {
                c.execute();
            }
            --this.notifyingDepth;
        }
    }

    public <P> void fireValueChanged(Object source, PropertyId2<ValueObserver2<P>> pid, P newValue, P oldValue) {
        ValueObserver2.ValueChangedEvent<P> event = new ValueObserver2.ValueChangedEvent<P>(source, pid, newValue, oldValue);
        this.fireEvent(event);
        AllPropertyObserver.ValueChangedEvent event2 = new AllPropertyObserver.ValueChangedEvent(source, allProperty, newValue, oldValue);
        this.fireEvent(event2);
    }

    public <P> void fireElementAdded(Object source, PropertyId2<CollectionObserver2<P>> pid, P addedValue) {
        CollectionObserver2.ElementAddedEvent<P> event = new CollectionObserver2.ElementAddedEvent<P>(source, pid, addedValue);
        this.fireEvent(event);
        AllPropertyObserver.ElementAddedEvent event2 = new AllPropertyObserver.ElementAddedEvent(source, allProperty, addedValue);
        this.fireEvent(event2);
    }

    public <P> void fireElementRemoved(Object source, PropertyId2<CollectionObserver2<P>> pid, P removedValue) {
        CollectionObserver2.ElementRemovedEvent<P> event = new CollectionObserver2.ElementRemovedEvent<P>(source, pid, removedValue);
        this.fireEvent(event);
        AllPropertyObserver.ElementRemovedEvent event2 = new AllPropertyObserver.ElementRemovedEvent(source, allProperty, removedValue);
        this.fireEvent(event2);
    }

    private static interface Command {
        public void execute();
    }
}

