/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BackupManagement;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackup;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackupRoot;
import com.clustercontrol.cloud.aws.presenter.InstanceBackup;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstanceBackup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InstanceBackupRoot
extends Element
implements IInstanceBackupRoot {
    private BackupManagement backupManagement;
    private List<InstanceBackup> instanceBackups;

    public InstanceBackupRoot(BackupManagement backupManagement) {
        this.backupManagement = backupManagement;
    }

    @Override
    public void update() throws CloudModelException {
        List cloudInstanceBackup = Collections.emptyList();
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            cloudInstanceBackup = endpoint.getInstanceBackupsByRegion(this.getBackupManagement().getRegion().getRegionName());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        this.internalUpdate(cloudInstanceBackup);
        super.update();
    }

    public boolean isInitialized() {
        return this.instanceBackups != null;
    }

    private List<InstanceBackup> getInstanceBackupsList() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.instanceBackups;
    }

    public void internalUpdate(List<CloudInstanceBackup> cloudInstancesBackups) throws CloudModelException {
        if (this.isInitialized()) {
            ArrayList<InstanceBackup> instancesBackupsTemp = new ArrayList<InstanceBackup>(this.instanceBackups);
            ArrayList<CloudInstanceBackup> cloudInstanceBackupsTemp = new ArrayList<CloudInstanceBackup>(cloudInstancesBackups);
            Iterator cloudInstanceBackupsIter = cloudInstanceBackupsTemp.iterator();
            block0: while (cloudInstanceBackupsIter.hasNext()) {
                CloudInstanceBackup cib = (CloudInstanceBackup)cloudInstanceBackupsIter.next();
                Iterator instanceBackupsIter = instancesBackupsTemp.iterator();
                while (instanceBackupsIter.hasNext()) {
                    InstanceBackup i = (InstanceBackup)instanceBackupsIter.next();
                    if (!cib.getImageId().equals(i.getImageId()) || !this.getBackupManagement().getRegion().getRegionName().equals(cib.getRegion())) continue;
                    i.internalUpdate(cib);
                    instanceBackupsIter.remove();
                    cloudInstanceBackupsIter.remove();
                    continue block0;
                }
            }
            for (InstanceBackup i : instancesBackupsTemp) {
                this.getInstanceBackupsList().remove(i);
                this.fireElementRemoved(IInstanceBackupRoot.p2.instanceBackups, i);
            }
            for (CloudInstanceBackup cib : cloudInstanceBackupsTemp) {
                InstanceBackup newInstanceBackup = InstanceBackup.createInstanceBackup(this, cib);
                this.getInstanceBackupsList().add(newInstanceBackup);
                this.fireElementAdded(IInstanceBackupRoot.p2.instanceBackups, newInstanceBackup);
            }
        } else {
            ArrayList<InstanceBackup> tempInstanceBackups = new ArrayList<InstanceBackup>();
            for (CloudInstanceBackup instanceBackup : cloudInstancesBackups) {
                tempInstanceBackups.add(InstanceBackup.createInstanceBackup(this, instanceBackup));
            }
            this.instanceBackups = tempInstanceBackups;
        }
    }

    @Override
    public BackupManagement getBackupManagement() {
        return this.backupManagement;
    }

    public InstanceBackup[] getInstanceBackups() {
        return this.getInstanceBackupsList().toArray(new InstanceBackup[0]);
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.backupManagement.getCloudResourceManager();
    }

    @Override
    public IInstanceBackup createInstanceBackup(CreateInstanceBackupRequest request) {
        com.clustercontrol.ws.cloud.CreateInstanceBackupRequest wsRequest = new com.clustercontrol.ws.cloud.CreateInstanceBackupRequest();
        wsRequest.setRegion(this.getBackupManagement().getRegion().getRegionName());
        wsRequest.setInstanceId(request.getInstanceId());
        wsRequest.setImageName(request.getImageName());
        wsRequest.setDescription(request.getDescription());
        wsRequest.setNoReboot(request.getNoReboot());
        wsRequest.setWithEBSVolume(request.getWithEBSVolume());
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudInstanceBackup backup = endpoint.addInstanceBackup(wsRequest);
            InstanceBackup newBackup = InstanceBackup.createInstanceBackup(this, backup);
            this.instanceBackups.add(newBackup);
            this.fireElementAdded(IInstanceBackupRoot.p2.instanceBackups, newBackup);
            return newBackup;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void deleteInstanceBackup(String imageId) {
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            endpoint.removeInstanceBackup(this.backupManagement.getRegion().getRegionName(), imageId);
            InstanceBackup removeBackup = this.getInstanceBackup(imageId);
            this.instanceBackups.remove(removeBackup);
            this.fireElementRemoved(IInstanceBackupRoot.p2.instanceBackups, removeBackup);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public InstanceBackup getInstanceBackup(String imageId) {
        for (InstanceBackup backup : this.instanceBackups) {
            if (!backup.getImageId().equals(imageId)) continue;
            return backup;
        }
        return null;
    }
}

