/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.GroupIdentifier;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.InstanceRoot;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.Region;
import com.clustercontrol.cloud.aws.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.InstanceStateChange;
import com.clustercontrol.ws.cloud.NodeDetail;
import com.clustercontrol.ws.cloud.StartInstanceRequest;
import com.clustercontrol.ws.cloud.StopInstanceRequest;
import com.clustercontrol.ws.cloud.Tag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class Instance
extends Element
implements IInstance {
    private InstanceRoot instanceRoot;
    private String facilityId;
    private String facilityName;
    private String instanceId;
    private String instanceName;
    private String platform;
    private String cloudId;
    private String cloudUserId;
    private String availavilityZone;
    private List<GroupIdentifier> securityGroups = new ArrayList<GroupIdentifier>();
    private String publicDnsName;
    private String imageId;
    private String rootDeviceType;
    private IInstance.StateType state;
    private IInstance.RegistStateType registState;
    private String type;
    private String keyPair;
    private Date launchTime;
    private List<IInstance.Tag> tags;
    private String templateId;
    private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
    private Date regDate;
    private Date updateDate;
    private String regUser;
    private String updateUser;

    public Instance(InstanceRoot instanceRoot) {
        this.instanceRoot = instanceRoot;
    }

    @Override
    public InstanceRoot getInstanceRoot() {
        return this.instanceRoot;
    }

    public void setInstanceRoot(InstanceRoot instanceRoot) {
        this.instanceRoot = instanceRoot;
    }

    @Override
    public String getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.internalSet("facilityId", IInstance.p2.facilityId, facilityId);
    }

    @Override
    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.internalSet("facilityName", IInstance.p2.facilityName, facilityName);
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Override
    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @Override
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    public void setCloudUserId(String cloudUserId) {
        this.cloudUserId = cloudUserId;
    }

    @Override
    public Region getRegion() {
        return this.instanceRoot.getRegion();
    }

    @Override
    public String getAvailabilityZone() {
        return this.availavilityZone;
    }

    public void setAvailavilityZone(String availavilityZone) {
        this.availavilityZone = availavilityZone;
    }

    @Override
    public List<GroupIdentifier> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<GroupIdentifier> securityGroups) {
        this.securityGroups = securityGroups;
    }

    @Override
    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    @Override
    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    @Override
    public IInstance.StateType getState() {
        return this.state;
    }

    public void setState(IInstance.StateType state) {
        this.internalSet("state", IInstance.p2.state, state);
    }

    @Override
    public IInstance.RegistStateType getRegistState() {
        return this.registState;
    }

    public void setRegistState(IInstance.RegistStateType registState) {
        this.registState = registState;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public Date getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    @Override
    public List<IInstance.Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<IInstance.Tag> tags) {
        this.tags = tags;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @Override
    public Date getRegDate() {
        return this.regDate;
    }

    public void setRegDate(Date regDate) {
        this.regDate = regDate;
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    public void setRegUser(String regUser) {
        this.regUser = regUser;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public void update() throws InvalidStateException {
        CloudInstance cloudInstance = CacheService.getSingleton().get(this, CloudInstance.class);
        if (cloudInstance == null) {
            try {
                cloudInstance = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).getInstance(this.getRegion().getRegionName(), this.getInstanceId());
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.error((Object)"faild to get repositry tree.", (Throwable)e);
            }
        } else {
            CacheService.getSingleton().remove(this);
        }
        if (cloudInstance != null) {
            this.internalUpdate(cloudInstance);
        }
        super.update();
    }

    public void internalUpdate(CloudInstance cloudInstance) {
        this.overwriteByCloudInstance(cloudInstance);
    }

    protected void overwriteByCloudInstance(CloudInstance cloudInstance) {
        this.setFacilityId(cloudInstance.getFacilityId());
        this.setFacilityName(cloudInstance.getFacilityName());
        this.setInstanceId(cloudInstance.getInstanceId());
        this.setInstanceName(cloudInstance.getInstanceName());
        this.setPlatform(cloudInstance.getPlatform() == null ? "LINUX" : "WINDOWS");
        this.setCloudId(cloudInstance.getCloudId());
        this.setCloudUserId(cloudInstance.getCloudUserId());
        this.setAvailavilityZone(cloudInstance.getAvailabilityZone());
        ArrayList<GroupIdentifier> gis = new ArrayList<GroupIdentifier>();
        for (com.clustercontrol.ws.cloud.GroupIdentifier sg : cloudInstance.getSecurityGroups()) {
            GroupIdentifier gi = new GroupIdentifier();
            gi.setGroupId(sg.getGroupId());
            gi.setGroupName(sg.getGroupName());
            gis.add(gi);
        }
        this.setSecurityGroups(gis);
        this.setPublicDnsName(cloudInstance.getPublicDnsName());
        this.setImageId(cloudInstance.getImageId());
        this.setRootDeviceType(cloudInstance.getRootDeviceType());
        this.setState(cloudInstance.getState() != null ? IInstance.StateType.valueOf(cloudInstance.getState().value()) : null);
        this.setRegistState(IInstance.RegistStateType.valueOf(cloudInstance.getRegistState().value()));
        this.setType(cloudInstance.getInstanceType());
        this.setKeyPair(cloudInstance.getKeyPair());
        this.setLaunchTime(cloudInstance.getLaunchTime() != null ? new Date(cloudInstance.getLaunchTime()) : null);
        ArrayList<IInstance.Tag> tags = new ArrayList<IInstance.Tag>();
        for (Tag t : cloudInstance.getTags()) {
            tags.add(new IInstance.Tag(t.getName(), t.getValue()));
        }
        this.setTags(tags);
        this.setTemplateId(cloudInstance.getTemplateId());
        ArrayList<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        for (com.clustercontrol.ws.cloud.BlockDeviceMapping d : cloudInstance.getBlockDeviceMappings()) {
            blockDeviceMappings.add(new BlockDeviceMapping(d.getVolumeId(), d.getDeviceName()));
        }
        this.setBlockDeviceMappings(blockDeviceMappings);
        this.setRegDate(cloudInstance.getRegDate() != null ? new Date(cloudInstance.getRegDate()) : null);
        this.setUpdateDate(cloudInstance.getUpdateDate() != null ? new Date(cloudInstance.getUpdateDate()) : null);
        this.setRegUser(cloudInstance.getRegUser());
        this.setUpdateUser(cloudInstance.getUpdateUser());
        this.setTemplateId(cloudInstance.getTemplateId());
    }

    public static Instance createInstance(InstanceRoot root, CloudInstance cloudInstance) {
        Instance instance = new Instance(root);
        instance.overwriteByCloudInstance(cloudInstance);
        return instance;
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.instanceRoot.getCloudResourceManager();
    }

    @Override
    public void start() {
        this.start(false, null, null);
    }

    @Override
    public void stop() {
        this.stop(false, null, null);
    }

    @Override
    public void attachStorage(String volumeId, String device) {
        try {
            this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).attachStorage(this.getRegion().getRegionName(), this.getInstanceId(), volumeId, device);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void detachStorage(String volumeId) {
        try {
            this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).detachStorage(this.getRegion().getRegionName(), this.getInstanceId(), volumeId);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    @Override
    public void registNode(RegistNodeRequest request) {
        try {
            com.clustercontrol.ws.cloud.RegistNodeRequest wsRequest = new com.clustercontrol.ws.cloud.RegistNodeRequest();
            NodeDetail nodeDetail = new NodeDetail();
            nodeDetail.setDescription(request.getDescription());
            nodeDetail.setFacilityId(request.getFacilityId());
            nodeDetail.setFacilityName(request.getFacilityName());
            nodeDetail.setNodeName(request.getNodeName());
            nodeDetail.setReplaceNode(Boolean.valueOf(request.isReplaceNode()));
            wsRequest.setNodeDetail(nodeDetail);
            wsRequest.setRegion(this.getRegion().getRegionName());
            wsRequest.setInstanceId(this.getInstanceId());
            CloudInstance instance = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).registNode(wsRequest);
            this.internalUpdate(instance);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void start(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments) {
        StartInstanceRequest request = new StartInstanceRequest();
        request.setInstanceId(this.instanceId);
        request.setRegion(this.getRegion().getRegionName());
        request.setRunJobFlg(runJobFlg);
        request.setJobId(jobId);
        List cloudArguments = request.getArguments();
        if (arguments != null) {
            for (TemplateJobsArgument argument : arguments) {
                com.clustercontrol.ws.cloud.TemplateJobsArgument cloudArgument = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
                cloudArgument.setJobId(argument.getJobId());
                cloudArgument.setArg(argument.getArg());
                cloudArguments.add(cloudArgument);
            }
        }
        try {
            InstanceStateChange change = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).startInstance(request);
            this.setState(IInstance.StateType.valueOf(change.getCurrentState().value()));
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void stop(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments) {
        StopInstanceRequest request = new StopInstanceRequest();
        request.setInstanceId(this.instanceId);
        request.setRegion(this.getRegion().getRegionName());
        request.setRunJobFlg(runJobFlg);
        request.setJobId(jobId);
        List cloudArguments = request.getArguments();
        if (arguments != null) {
            for (TemplateJobsArgument argument : arguments) {
                com.clustercontrol.ws.cloud.TemplateJobsArgument cloudArgument = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
                cloudArgument.setJobId(argument.getJobId());
                cloudArgument.setArg(argument.getArg());
                cloudArguments.add(cloudArgument);
            }
        }
        try {
            InstanceStateChange change = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).stopInstance(request);
            this.setState(IInstance.StateType.valueOf(change.getCurrentState().value()));
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }
}

