/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.Category;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IIdentityManagement;
import com.clustercontrol.cloud.aws.presenter.Identity;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudType;
import com.clustercontrol.ws.cloud.CloudUser;
import com.clustercontrol.ws.cloud.Filter;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class IdentityManagement
extends Element
implements IIdentityManagement {
    private CloudResourceManager root;
    private final List<ICategory> categories = new ArrayList<ICategory>();

    public IdentityManagement(CloudResourceManager root) {
        this.root = root;
        try {
            this.restoreIdentityTree();
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.root;
    }

    public Category[] getCategories() {
        return this.categories.toArray(new Category[0]);
    }

    private void restoreIdentityTree() throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception {
        CloudEndpoint ce = this.root.getEndpoint(CloudEndpoint.class);
        List cts = ce.getAllCloudType();
        for (CloudType ct : cts) {
            Category category = Category.createCategory(ct, this.root, this);
            Filter f = new Filter();
            f.setName("cloudId");
            f.getValues().add(ct.getCloudId());
            List cus = ce.getCloudUsers(Arrays.asList(f));
            HashMap<String, Identity> identityMap = new HashMap<String, Identity>();
            ArrayList tempList = new ArrayList(cus);
            Iterator tempIter = tempList.iterator();
            while (tempIter.hasNext()) {
                CloudUser cu = (CloudUser)tempIter.next();
                if (cu.getParentCloudUserId() != null) continue;
                Identity id = Identity.createIdentiry(cu, this.root, category, null);
                category.addChildIdentity(id);
                tempIter.remove();
                identityMap.put(id.getId(), id);
            }
            for (CloudUser cu : tempList) {
                Identity parent = (Identity)identityMap.get(cu.getParentCloudUserId());
                if (parent != null) {
                    Identity child = Identity.createIdentiry(cu, this.root, category, parent);
                    parent.addChildIdentity(child);
                    continue;
                }
                Logger logger = Logger.getLogger(IdentityManagement.class);
                logger.warn((Object)("orphen : " + cu.getCloudUserId()));
            }
            this.categories.add(category);
        }
    }

    @Override
    public IIdentity getIdentity(String id) {
        for (ICategory category : this.categories) {
            for (IIdentity parent : category.getIdentities()) {
                if (parent.getId().equals(id)) {
                    return parent;
                }
                for (IIdentity child : parent.getIdentities()) {
                    if (!child.getId().equals(id)) continue;
                    return child;
                }
            }
        }
        return null;
    }

    @Override
    public void each(IIdentityManagement.Verifier v) {
        for (ICategory category : this.categories) {
            for (IIdentity parent : category.getIdentities()) {
                v.velify(parent);
                for (IIdentity child : parent.getIdentities()) {
                    v.velify(child);
                }
            }
        }
    }

    @Override
    public void update() throws InvalidStateException {
        for (ICategory c : this.categories) {
            c.update();
        }
        super.update();
    }
}

