/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.AccessKey;
import com.clustercontrol.cloud.aws.presenter.Category;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateIdentityRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.ModifyIdentityRequest;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudUser;
import com.clustercontrol.ws.cloud.CloudUserType;
import com.clustercontrol.ws.cloud.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Identity
extends Element
implements IIdentity {
    private String name;
    private String id;
    private AccessKey key;
    private Category category;
    private Identity parent;
    private List<Identity> identities = new ArrayList<Identity>();
    private String description;
    private String hinemosUserId;
    private Date regDate;
    private String regUser;
    private Date updateDate;
    private String updateUser;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AccessKey getAccessKey() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Identity[] getIdentities() {
        return this.identities.toArray(new Identity[0]);
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public Identity getParent() {
        return this.parent;
    }

    @Override
    public String getHinemosUserId() {
        return this.hinemosUserId;
    }

    @Override
    public Date getRegDate() {
        return this.regDate;
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setName(String name) {
        if (this.name == null ? name == null : this.name.equals(name)) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        this.firePropertyChanged2(this, IIdentity.p2.name, oldName, this.name);
    }

    public void setId(String id) {
        if (this.id == null ? id == null : this.id.equals(id)) {
            return;
        }
        String oldId = this.id;
        this.id = id;
        this.firePropertyChanged2(this, IIdentity.p2.id, oldId, this.name);
    }

    public void setAccessKey(AccessKey key) {
        if (this.key == null ? key == null : this.key.equals(key)) {
            return;
        }
        AccessKey oldkey = this.key;
        this.key = key;
        this.firePropertyChanged2(this, IIdentity.p2.accessKey, oldkey, this.key);
    }

    public void setDescription(String description) {
        if (this.description == null ? description == null : this.description.equals(description)) {
            return;
        }
        String oldDescription = this.description;
        this.description = description;
        this.firePropertyChanged2(this, IIdentity.p2.description, oldDescription, this.description);
    }

    public void setCategory(Category category) {
        if (this.category == null ? category == null : this.category.equals(category)) {
            return;
        }
        Category oldCategory = this.category;
        this.category = category;
        this.firePropertyChanged2(this, IIdentity.p2.category, oldCategory, this.category);
    }

    public void setParent(Identity parent) {
        if (this.parent == null ? parent == null : this.parent.equals(parent)) {
            return;
        }
        Identity oldParent = this.parent;
        this.parent = parent;
        this.firePropertyChanged2(this, IIdentity.p2.parent, oldParent, this.parent);
    }

    public void setHinemosUserId(String hinemosUserId) {
        if (this.hinemosUserId == null ? hinemosUserId == null : this.hinemosUserId.equals(hinemosUserId)) {
            return;
        }
        String oldhinemosUserId = this.hinemosUserId;
        this.hinemosUserId = hinemosUserId;
        this.firePropertyChanged2(this, IIdentity.p2.hinemosUserId, oldhinemosUserId, this.hinemosUserId);
    }

    public void setRegDate(Date regDate) {
        if (this.regDate == null ? regDate == null : this.regDate.equals(regDate)) {
            return;
        }
        Date oldRegDate = this.regDate;
        this.regDate = regDate;
        this.firePropertyChanged2(this, IIdentity.p2.regDate, oldRegDate, this.regDate);
    }

    public void setUpdateDate(Date updateDate) {
        if (this.updateDate == null ? updateDate == null : this.updateDate.equals(updateDate)) {
            return;
        }
        Date oldUpdateDate = this.updateDate;
        this.updateDate = updateDate;
        this.firePropertyChanged2(this, IIdentity.p2.regDate, oldUpdateDate, this.updateDate);
    }

    public void setRegUser(String regUser) {
        if (this.regUser == null ? regUser == null : this.regUser.equals(regUser)) {
            return;
        }
        String oldRegUser = this.regUser;
        this.regUser = regUser;
        this.firePropertyChanged2(this, IIdentity.p2.regUser, oldRegUser, this.regUser);
    }

    public void setUpdateUser(String updateUser) {
        if (this.updateUser == null ? updateUser == null : this.updateUser.equals(updateUser)) {
            return;
        }
        String oldUpdateUser = this.updateUser;
        this.updateUser = updateUser;
        this.firePropertyChanged2(this, IIdentity.p2.updateUser, oldUpdateUser, this.updateUser);
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.category.getCloudManager();
    }

    public void addChildIdentity(Identity child) {
        if (!this.identities.contains(child)) {
            this.identities.add(child);
            this.fireElementAdded(IIdentity.p2.identities, child);
        }
    }

    public void removeChildIdentity(IIdentity child) {
        if (this.identities.contains(child)) {
            this.identities.remove(child);
            this.fireElementRemoved(IIdentity.p2.identities, child);
        }
    }

    @Override
    public void update() throws InvalidStateException {
        CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        CloudUser cu = null;
        try {
            cu = ce.getCloudUser(this.getId());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        if (cu.getParentCloudUserId() == null) {
            if (this.getParent() != null) {
                throw new CloudModelException();
            }
        } else if (this.getParent() != null) {
            if (!cu.getParentCloudUserId().equals(this.getParent().getId())) {
                throw new CloudModelException();
            }
        } else {
            throw new CloudModelException();
        }
        this.setName(cu.getCloudUserName());
        this.setDescription(cu.getDescription());
        AccessKey key = new AccessKey();
        key.setAccessKey(cu.getAccessKey());
        key.setSecretKey(cu.getSecretKey());
        this.setAccessKey(key);
        this.setHinemosUserId(cu.getUserId());
        this.setRegDate(new Date(cu.getRegDate()));
        this.setRegUser(cu.getRegUser());
        this.setUpdateDate(new Date(cu.getUpdateDate()));
        this.setUpdateUser(cu.getUpdateUser());
        if (cu.getParentCloudUserId() == null) {
            try {
                Filter f = new Filter();
                f.setName("parentCloudUserId");
                f.getValues().add(cu.getCloudUserId());
                List users = ce.getCloudUsers(Arrays.asList(f));
                ArrayList<Identity> identityList = new ArrayList<Identity>(this.identities);
                ArrayList<Identity> newIdentityList = new ArrayList<Identity>();
                Iterator userIter = users.iterator();
                while (userIter.hasNext()) {
                    CloudUser childCu = (CloudUser)userIter.next();
                    Iterator identityIter = identityList.iterator();
                    while (identityIter.hasNext()) {
                        Identity id = (Identity)identityIter.next();
                        if (!childCu.getCloudUserId().equals(id.getId())) continue;
                        newIdentityList.add(id);
                        userIter.remove();
                        identityIter.remove();
                    }
                }
                for (Identity id : identityList) {
                    try {
                        this.removeChildIdentity(id);
                    }
                    catch (Exception e) {
                        throw new CloudModelException(e);
                    }
                }
                for (CloudUser childCu : users) {
                    try {
                        Identity child = Identity.createIdentiry(childCu, this.getCloudResourceManager(), this.getCategory(), this);
                        this.addChildIdentity(child);
                    }
                    catch (Exception e) {
                        throw new CloudModelException(e);
                    }
                }
                for (Identity id : this.identities) {
                    id.update();
                }
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        super.update();
    }

    @Override
    public void createChildIdentity(CreateIdentityRequest request) {
        CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        CloudUser cu = new CloudUser();
        cu.setCloudUserName(request.name);
        cu.setCloudUserId(request.id);
        cu.setDescription(request.description);
        cu.setAccessKey(request.key.getAccessKey());
        cu.setSecretKey(request.key.getSecretKey());
        cu.setCloudUserType(CloudUserType.CHILD);
        cu.setParentCloudUserId(this.getId());
        cu.setUserId(request.hinemosUserId);
        try {
            CloudUser newCu = ce.addCloudUser(cu);
            Identity childId = Identity.createIdentiry(newCu, this.getCloudResourceManager(), this.category, this);
            this.addChildIdentity(childId);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void modifyIdentity(ModifyIdentityRequest request) {
        CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        CloudUser cu = new CloudUser();
        cu.setCloudUserName(request.name);
        cu.setCloudUserId(this.getId());
        cu.setDescription(request.description);
        cu.setAccessKey(request.key.getAccessKey());
        cu.setSecretKey(request.key.getSecretKey());
        cu.setUserId(request.hinemosUserId);
        try {
            CloudUser updateCu = ce.modifyCloudUser(cu);
            this.setName(updateCu.getCloudUserName());
            this.setDescription(updateCu.getDescription());
            AccessKey key = new AccessKey();
            key.setAccessKey(updateCu.getAccessKey());
            key.setSecretKey(updateCu.getSecretKey());
            this.setAccessKey(key);
            this.setHinemosUserId(updateCu.getUserId());
            this.setRegDate(new Date(updateCu.getRegDate()));
            this.setRegUser(updateCu.getRegUser());
            this.setUpdateDate(new Date(updateCu.getUpdateDate()));
            this.setUpdateUser(updateCu.getUpdateUser());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void deleteChildIdentity(String childId) {
        CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        try {
            ce.removeCloudUser(childId);
            IIdentity child = this.getCategory().getIdentityManagement().getIdentity(childId);
            this.removeChildIdentity(child);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public static Identity createIdentiry(CloudUser cu, CloudResourceManager root, Category category, Identity parent) {
        Identity id = new Identity();
        id.setId(cu.getCloudUserId());
        id.setName(cu.getCloudUserName());
        id.setDescription(cu.getDescription());
        AccessKey key = new AccessKey();
        key.setAccessKey(cu.getAccessKey());
        key.setSecretKey(cu.getSecretKey());
        id.setAccessKey(key);
        id.setCategory(category);
        id.setHinemosUserId(cu.getUserId());
        id.setRegDate(new Date(cu.getRegDate()));
        id.setRegUser(cu.getRegUser());
        id.setUpdateDate(new Date(cu.getUpdateDate()));
        id.setUpdateUser(cu.getUpdateUser());
        if (parent != null) {
            id.setParent(parent);
            parent.addChildIdentity(id);
        }
        return id;
    }
}

