/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.aws.presenter.GroupIdentifier;
import com.clustercontrol.cloud.aws.presenter.ICloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.IInstanceRoot;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.aws.presenter.ValueObserver2;
import java.util.Date;
import java.util.List;

public interface IInstance
extends IElement {
    public IInstanceRoot getInstanceRoot();

    public String getFacilityId();

    public String getFacilityName();

    public String getInstanceId();

    public String getInstanceName();

    public String getPlatform();

    public String getCloudId();

    public String getCloudUserId();

    public IRegion getRegion();

    public String getAvailabilityZone();

    public List<GroupIdentifier> getSecurityGroups();

    public String getPublicDnsName();

    public String getImageId();

    public String getRootDeviceType();

    public StateType getState();

    public RegistStateType getRegistState();

    public String getType();

    public String getKeyPair();

    public Date getLaunchTime();

    public List<Tag> getTags();

    public String getTemplateId();

    public Date getRegDate();

    public Date getUpdateDate();

    public String getRegUser();

    public String getUpdateUser();

    public void start();

    public void stop();

    public ICloudResourceManager getCloudResourceManager();

    public void registNode(RegistNodeRequest var1);

    public void attachStorage(String var1, String var2);

    public void detachStorage(String var1);

    public List<BlockDeviceMapping> getBlockDeviceMappings();

    public void start(Boolean var1, String var2, List<TemplateJobsArgument> var3);

    public void stop(Boolean var1, String var2, List<TemplateJobsArgument> var3);

    public static interface p2 {
        public static final PropertyId2<ValueObserver2<StateType>> state = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2();
    }

    public static class Tag {
        private String name;
        private String value;

        public Tag() {
        }

        public Tag(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RegistStateType {
        registered(0),
        unregistered(1),
        deleted(2);

        private short num;

        private RegistStateType(short num) {
            this.num = num;
        }

        public short number() {
            return this.num;
        }

        public static RegistStateType byNumber(short num) {
            for (RegistStateType type : RegistStateType.values()) {
                if (type.number() != num) continue;
                return type;
            }
            return null;
        }
    }

    public static enum StateType {
        pending("pending"),
        running("running"),
        shutting_down("shutting-down"),
        terminated("terminated"),
        stopping("stopping"),
        stopped("stopped"),
        rebooting("rebooting");

        private final String label;

        private StateType(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }

        public static StateType byLabel(String label) {
            String name = label.replace('-', '_');
            return StateType.valueOf(name);
        }
    }
}

